/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.CoverageFilterCriteria;
import software.amazon.awssdk.services.guardduty.model.CoverageSortCriteria;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCoverageRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, ListCoverageRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(ListCoverageRequest.getter(ListCoverageRequest::detectorId)).setter(ListCoverageRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCoverageRequest.getter(ListCoverageRequest::nextToken)).setter(ListCoverageRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCoverageRequest.getter(ListCoverageRequest::maxResults)).setter(ListCoverageRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<CoverageFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(ListCoverageRequest.getter(ListCoverageRequest::filterCriteria)).setter(ListCoverageRequest.setter(Builder::filterCriteria)).constructor(CoverageFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<CoverageSortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortCriteria").getter(ListCoverageRequest.getter(ListCoverageRequest::sortCriteria)).setter(ListCoverageRequest.setter(Builder::sortCriteria)).constructor(CoverageSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_CRITERIA_FIELD, SORT_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCoverageRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final String nextToken;
    private final Integer maxResults;
    private final CoverageFilterCriteria filterCriteria;
    private final CoverageSortCriteria sortCriteria;

    private ListCoverageRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filterCriteria = builder.filterCriteria;
        this.sortCriteria = builder.sortCriteria;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final CoverageFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final CoverageSortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageRequest)) {
            return false;
        }
        ListCoverageRequest other = (ListCoverageRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"ListCoverageRequest").add("DetectorId", (Object)this.detectorId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("FilterCriteria", (Object)this.filterCriteria()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "SortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("sortCriteria", SORT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageRequest, T> g) {
        return obj -> g.apply((ListCoverageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String nextToken;
        private Integer maxResults;
        private CoverageFilterCriteria filterCriteria;
        private CoverageSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filterCriteria(model.filterCriteria);
            this.sortCriteria(model.sortCriteria);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final CoverageFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CoverageFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CoverageFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final CoverageSortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(CoverageSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(CoverageSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCoverageRequest build() {
            return new ListCoverageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCoverageRequest> {
        public Builder detectorId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filterCriteria(CoverageFilterCriteria var1);

        default public Builder filterCriteria(Consumer<CoverageFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((CoverageFilterCriteria)((CoverageFilterCriteria.Builder)CoverageFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder sortCriteria(CoverageSortCriteria var1);

        default public Builder sortCriteria(Consumer<CoverageSortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((CoverageSortCriteria)((CoverageSortCriteria.Builder)CoverageSortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

