/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AutoEnableMembers;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfigurationResult;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeaturesConfigurationsResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigurationResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnable").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::autoEnable)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final SdkField<Boolean> MEMBER_ACCOUNT_LIMIT_REACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MemberAccountLimitReached").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::memberAccountLimitReached)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::memberAccountLimitReached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountLimitReached").build()}).build();
    private static final SdkField<OrganizationDataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::dataSources)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::dataSources)).constructor(OrganizationDataSourceConfigurationsResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final SdkField<List<OrganizationFeatureConfigurationResult>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::features)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationFeatureConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::nextToken)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEnableOrganizationMembers").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::autoEnableOrganizationMembersAsString)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::autoEnableOrganizationMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableOrganizationMembers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD, MEMBER_ACCOUNT_LIMIT_REACHED_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD, NEXT_TOKEN_FIELD, AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("autoEnable", AUTO_ENABLE_FIELD);
            this.put("memberAccountLimitReached", MEMBER_ACCOUNT_LIMIT_REACHED_FIELD);
            this.put("dataSources", DATA_SOURCES_FIELD);
            this.put("features", FEATURES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("autoEnableOrganizationMembers", AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD);
        }
    });
    private final Boolean autoEnable;
    private final Boolean memberAccountLimitReached;
    private final OrganizationDataSourceConfigurationsResult dataSources;
    private final List<OrganizationFeatureConfigurationResult> features;
    private final String nextToken;
    private final String autoEnableOrganizationMembers;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.memberAccountLimitReached = builder.memberAccountLimitReached;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
        this.nextToken = builder.nextToken;
        this.autoEnableOrganizationMembers = builder.autoEnableOrganizationMembers;
    }

    @Deprecated
    public final Boolean autoEnable() {
        return this.autoEnable;
    }

    public final Boolean memberAccountLimitReached() {
        return this.memberAccountLimitReached;
    }

    @Deprecated
    public final OrganizationDataSourceConfigurationsResult dataSources() {
        return this.dataSources;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<OrganizationFeatureConfigurationResult> features() {
        return this.features;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final AutoEnableMembers autoEnableOrganizationMembers() {
        return AutoEnableMembers.fromValue(this.autoEnableOrganizationMembers);
    }

    public final String autoEnableOrganizationMembersAsString() {
        return this.autoEnableOrganizationMembers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableOrganizationMembersAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse)((Object)obj);
        return Objects.equals(this.autoEnable(), other.autoEnable()) && Objects.equals(this.memberAccountLimitReached(), other.memberAccountLimitReached()) && Objects.equals(this.dataSources(), other.dataSources()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.autoEnableOrganizationMembersAsString(), other.autoEnableOrganizationMembersAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigurationResponse").add("AutoEnable", (Object)this.autoEnable()).add("MemberAccountLimitReached", (Object)this.memberAccountLimitReached()).add("DataSources", (Object)this.dataSources()).add("Features", this.hasFeatures() ? this.features() : null).add("NextToken", (Object)this.nextToken()).add("AutoEnableOrganizationMembers", (Object)this.autoEnableOrganizationMembersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnable()));
            }
            case "MemberAccountLimitReached": {
                return Optional.ofNullable(clazz.cast(this.memberAccountLimitReached()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AutoEnableOrganizationMembers": {
                return Optional.ofNullable(clazz.cast(this.autoEnableOrganizationMembersAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private Boolean autoEnable;
        private Boolean memberAccountLimitReached;
        private OrganizationDataSourceConfigurationsResult dataSources;
        private List<OrganizationFeatureConfigurationResult> features = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String autoEnableOrganizationMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            this.autoEnable(model.autoEnable);
            this.memberAccountLimitReached(model.memberAccountLimitReached);
            this.dataSources(model.dataSources);
            this.features(model.features);
            this.nextToken(model.nextToken);
            this.autoEnableOrganizationMembers(model.autoEnableOrganizationMembers);
        }

        @Deprecated
        public final Boolean getAutoEnable() {
            return this.autoEnable;
        }

        @Deprecated
        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        @Deprecated
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final Boolean getMemberAccountLimitReached() {
            return this.memberAccountLimitReached;
        }

        public final void setMemberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
        }

        @Override
        public final Builder memberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
            return this;
        }

        @Deprecated
        public final OrganizationDataSourceConfigurationsResult.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(OrganizationDataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(OrganizationDataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<OrganizationFeatureConfigurationResult.Builder> getFeatures() {
            List<OrganizationFeatureConfigurationResult.Builder> result = OrganizationFeaturesConfigurationsResultsCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<OrganizationFeatureConfigurationResult.BuilderImpl> features) {
            this.features = OrganizationFeaturesConfigurationsResultsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<OrganizationFeatureConfigurationResult> features) {
            this.features = OrganizationFeaturesConfigurationsResultsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(OrganizationFeatureConfigurationResult ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<OrganizationFeatureConfigurationResult.Builder> ... features) {
            this.features(Stream.of(features).map(c -> (OrganizationFeatureConfigurationResult)((OrganizationFeatureConfigurationResult.Builder)OrganizationFeatureConfigurationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAutoEnableOrganizationMembers() {
            return this.autoEnableOrganizationMembers;
        }

        public final void setAutoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
            return this;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(AutoEnableMembers autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers(autoEnableOrganizationMembers == null ? null : autoEnableOrganizationMembers.toString());
            return this;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        @Deprecated
        public Builder autoEnable(Boolean var1);

        public Builder memberAccountLimitReached(Boolean var1);

        @Deprecated
        public Builder dataSources(OrganizationDataSourceConfigurationsResult var1);

        @Deprecated
        default public Builder dataSources(Consumer<OrganizationDataSourceConfigurationsResult.Builder> dataSources) {
            return this.dataSources((OrganizationDataSourceConfigurationsResult)((OrganizationDataSourceConfigurationsResult.Builder)OrganizationDataSourceConfigurationsResult.builder().applyMutation(dataSources)).build());
        }

        public Builder features(Collection<OrganizationFeatureConfigurationResult> var1);

        public Builder features(OrganizationFeatureConfigurationResult ... var1);

        public Builder features(Consumer<OrganizationFeatureConfigurationResult.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder autoEnableOrganizationMembers(String var1);

        public Builder autoEnableOrganizationMembers(AutoEnableMembers var1);
    }
}

