/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Ec2NetworkInterfaceUidsCopier;
import software.amazon.awssdk.services.guardduty.model.IamInstanceProfile;
import software.amazon.awssdk.services.guardduty.model.ProductCode;
import software.amazon.awssdk.services.guardduty.model.ProductCodesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2Instance> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Ec2Instance.getter(Ec2Instance::availabilityZone)).setter(Ec2Instance.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageDescription").getter(Ec2Instance.getter(Ec2Instance::imageDescription)).setter(Ec2Instance.setter(Builder::imageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDescription").build()}).build();
    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceState").getter(Ec2Instance.getter(Ec2Instance::instanceState)).setter(Ec2Instance.setter(Builder::instanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()}).build();
    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(Ec2Instance.getter(Ec2Instance::iamInstanceProfile)).setter(Ec2Instance.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Ec2Instance.getter(Ec2Instance::instanceType)).setter(Ec2Instance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(Ec2Instance.getter(Ec2Instance::outpostArn)).setter(Ec2Instance.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostArn").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(Ec2Instance.getter(Ec2Instance::platform)).setter(Ec2Instance.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(Ec2Instance.getter(Ec2Instance::productCodes)).setter(Ec2Instance.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EC2_NETWORK_INTERFACE_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2NetworkInterfaceUids").getter(Ec2Instance.getter(Ec2Instance::ec2NetworkInterfaceUids)).setter(Ec2Instance.setter(Builder::ec2NetworkInterfaceUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2NetworkInterfaceUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, IMAGE_DESCRIPTION_FIELD, INSTANCE_STATE_FIELD, IAM_INSTANCE_PROFILE_FIELD, INSTANCE_TYPE_FIELD, OUTPOST_ARN_FIELD, PLATFORM_FIELD, PRODUCT_CODES_FIELD, EC2_NETWORK_INTERFACE_UIDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2Instance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String imageDescription;
    private final String instanceState;
    private final IamInstanceProfile iamInstanceProfile;
    private final String instanceType;
    private final String outpostArn;
    private final String platform;
    private final List<ProductCode> productCodes;
    private final List<String> ec2NetworkInterfaceUids;

    private Ec2Instance(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.imageDescription = builder.imageDescription;
        this.instanceState = builder.instanceState;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceType = builder.instanceType;
        this.outpostArn = builder.outpostArn;
        this.platform = builder.platform;
        this.productCodes = builder.productCodes;
        this.ec2NetworkInterfaceUids = builder.ec2NetworkInterfaceUids;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String imageDescription() {
        return this.imageDescription;
    }

    public final String instanceState() {
        return this.instanceState;
    }

    public final IamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String platform() {
        return this.platform;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public final boolean hasEc2NetworkInterfaceUids() {
        return this.ec2NetworkInterfaceUids != null && !(this.ec2NetworkInterfaceUids instanceof SdkAutoConstructList);
    }

    public final List<String> ec2NetworkInterfaceUids() {
        return this.ec2NetworkInterfaceUids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2NetworkInterfaceUids() ? this.ec2NetworkInterfaceUids() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Instance)) {
            return false;
        }
        Ec2Instance other = (Ec2Instance)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.imageDescription(), other.imageDescription()) && Objects.equals(this.instanceState(), other.instanceState()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.platform(), other.platform()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && this.hasEc2NetworkInterfaceUids() == other.hasEc2NetworkInterfaceUids() && Objects.equals(this.ec2NetworkInterfaceUids(), other.ec2NetworkInterfaceUids());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2Instance").add("AvailabilityZone", (Object)this.availabilityZone()).add("ImageDescription", (Object)this.imageDescription()).add("InstanceState", (Object)this.instanceState()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("InstanceType", (Object)this.instanceType()).add("OutpostArn", (Object)this.outpostArn()).add("Platform", (Object)this.platform()).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("Ec2NetworkInterfaceUids", this.hasEc2NetworkInterfaceUids() ? this.ec2NetworkInterfaceUids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ImageDescription": {
                return Optional.ofNullable(clazz.cast(this.imageDescription()));
            }
            case "InstanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceState()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "Ec2NetworkInterfaceUids": {
                return Optional.ofNullable(clazz.cast(this.ec2NetworkInterfaceUids()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("imageDescription", IMAGE_DESCRIPTION_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        map.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("outpostArn", OUTPOST_ARN_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("productCodes", PRODUCT_CODES_FIELD);
        map.put("ec2NetworkInterfaceUids", EC2_NETWORK_INTERFACE_UIDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2Instance, T> g) {
        return obj -> g.apply((Ec2Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String imageDescription;
        private String instanceState;
        private IamInstanceProfile iamInstanceProfile;
        private String instanceType;
        private String outpostArn;
        private String platform;
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> ec2NetworkInterfaceUids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Instance model) {
            this.availabilityZone(model.availabilityZone);
            this.imageDescription(model.imageDescription);
            this.instanceState(model.instanceState);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.instanceType(model.instanceType);
            this.outpostArn(model.outpostArn);
            this.platform(model.platform);
            this.productCodes(model.productCodes);
            this.ec2NetworkInterfaceUids(model.ec2NetworkInterfaceUids);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getImageDescription() {
            return this.imageDescription;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final String getInstanceState() {
            return this.instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodesCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodesCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodesCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEc2NetworkInterfaceUids() {
            if (this.ec2NetworkInterfaceUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2NetworkInterfaceUids;
        }

        public final void setEc2NetworkInterfaceUids(Collection<String> ec2NetworkInterfaceUids) {
            this.ec2NetworkInterfaceUids = Ec2NetworkInterfaceUidsCopier.copy(ec2NetworkInterfaceUids);
        }

        @Override
        public final Builder ec2NetworkInterfaceUids(Collection<String> ec2NetworkInterfaceUids) {
            this.ec2NetworkInterfaceUids = Ec2NetworkInterfaceUidsCopier.copy(ec2NetworkInterfaceUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2NetworkInterfaceUids(String ... ec2NetworkInterfaceUids) {
            this.ec2NetworkInterfaceUids(Arrays.asList(ec2NetworkInterfaceUids));
            return this;
        }

        public Ec2Instance build() {
            return new Ec2Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2Instance> {
        public Builder availabilityZone(String var1);

        public Builder imageDescription(String var1);

        public Builder instanceState(String var1);

        public Builder iamInstanceProfile(IamInstanceProfile var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfile)((IamInstanceProfile.Builder)IamInstanceProfile.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder instanceType(String var1);

        public Builder outpostArn(String var1);

        public Builder platform(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder ec2NetworkInterfaceUids(Collection<String> var1);

        public Builder ec2NetworkInterfaceUids(String ... var1);
    }
}

