/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.PublicAccessStatus;
import software.amazon.awssdk.services.guardduty.model.PublicAclIgnoreBehavior;
import software.amazon.awssdk.services.guardduty.model.PublicBucketRestrictBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicAccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicAccessConfiguration> {
    private static final SdkField<String> PUBLIC_ACL_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicAclAccess").getter(PublicAccessConfiguration.getter(PublicAccessConfiguration::publicAclAccessAsString)).setter(PublicAccessConfiguration.setter(Builder::publicAclAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAclAccess").build()}).build();
    private static final SdkField<String> PUBLIC_POLICY_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicPolicyAccess").getter(PublicAccessConfiguration.getter(PublicAccessConfiguration::publicPolicyAccessAsString)).setter(PublicAccessConfiguration.setter(Builder::publicPolicyAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicPolicyAccess").build()}).build();
    private static final SdkField<String> PUBLIC_ACL_IGNORE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicAclIgnoreBehavior").getter(PublicAccessConfiguration.getter(PublicAccessConfiguration::publicAclIgnoreBehaviorAsString)).setter(PublicAccessConfiguration.setter(Builder::publicAclIgnoreBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAclIgnoreBehavior").build()}).build();
    private static final SdkField<String> PUBLIC_BUCKET_RESTRICT_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicBucketRestrictBehavior").getter(PublicAccessConfiguration.getter(PublicAccessConfiguration::publicBucketRestrictBehaviorAsString)).setter(PublicAccessConfiguration.setter(Builder::publicBucketRestrictBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicBucketRestrictBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_ACL_ACCESS_FIELD, PUBLIC_POLICY_ACCESS_FIELD, PUBLIC_ACL_IGNORE_BEHAVIOR_FIELD, PUBLIC_BUCKET_RESTRICT_BEHAVIOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("publicAclAccess", PUBLIC_ACL_ACCESS_FIELD);
            this.put("publicPolicyAccess", PUBLIC_POLICY_ACCESS_FIELD);
            this.put("publicAclIgnoreBehavior", PUBLIC_ACL_IGNORE_BEHAVIOR_FIELD);
            this.put("publicBucketRestrictBehavior", PUBLIC_BUCKET_RESTRICT_BEHAVIOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String publicAclAccess;
    private final String publicPolicyAccess;
    private final String publicAclIgnoreBehavior;
    private final String publicBucketRestrictBehavior;

    private PublicAccessConfiguration(BuilderImpl builder) {
        this.publicAclAccess = builder.publicAclAccess;
        this.publicPolicyAccess = builder.publicPolicyAccess;
        this.publicAclIgnoreBehavior = builder.publicAclIgnoreBehavior;
        this.publicBucketRestrictBehavior = builder.publicBucketRestrictBehavior;
    }

    public final PublicAccessStatus publicAclAccess() {
        return PublicAccessStatus.fromValue(this.publicAclAccess);
    }

    public final String publicAclAccessAsString() {
        return this.publicAclAccess;
    }

    public final PublicAccessStatus publicPolicyAccess() {
        return PublicAccessStatus.fromValue(this.publicPolicyAccess);
    }

    public final String publicPolicyAccessAsString() {
        return this.publicPolicyAccess;
    }

    public final PublicAclIgnoreBehavior publicAclIgnoreBehavior() {
        return PublicAclIgnoreBehavior.fromValue(this.publicAclIgnoreBehavior);
    }

    public final String publicAclIgnoreBehaviorAsString() {
        return this.publicAclIgnoreBehavior;
    }

    public final PublicBucketRestrictBehavior publicBucketRestrictBehavior() {
        return PublicBucketRestrictBehavior.fromValue(this.publicBucketRestrictBehavior);
    }

    public final String publicBucketRestrictBehaviorAsString() {
        return this.publicBucketRestrictBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAclAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicPolicyAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAclIgnoreBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicBucketRestrictBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicAccessConfiguration)) {
            return false;
        }
        PublicAccessConfiguration other = (PublicAccessConfiguration)obj;
        return Objects.equals(this.publicAclAccessAsString(), other.publicAclAccessAsString()) && Objects.equals(this.publicPolicyAccessAsString(), other.publicPolicyAccessAsString()) && Objects.equals(this.publicAclIgnoreBehaviorAsString(), other.publicAclIgnoreBehaviorAsString()) && Objects.equals(this.publicBucketRestrictBehaviorAsString(), other.publicBucketRestrictBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PublicAccessConfiguration").add("PublicAclAccess", (Object)this.publicAclAccessAsString()).add("PublicPolicyAccess", (Object)this.publicPolicyAccessAsString()).add("PublicAclIgnoreBehavior", (Object)this.publicAclIgnoreBehaviorAsString()).add("PublicBucketRestrictBehavior", (Object)this.publicBucketRestrictBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicAclAccess": {
                return Optional.ofNullable(clazz.cast(this.publicAclAccessAsString()));
            }
            case "PublicPolicyAccess": {
                return Optional.ofNullable(clazz.cast(this.publicPolicyAccessAsString()));
            }
            case "PublicAclIgnoreBehavior": {
                return Optional.ofNullable(clazz.cast(this.publicAclIgnoreBehaviorAsString()));
            }
            case "PublicBucketRestrictBehavior": {
                return Optional.ofNullable(clazz.cast(this.publicBucketRestrictBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublicAccessConfiguration, T> g) {
        return obj -> g.apply((PublicAccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publicAclAccess;
        private String publicPolicyAccess;
        private String publicAclIgnoreBehavior;
        private String publicBucketRestrictBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicAccessConfiguration model) {
            this.publicAclAccess(model.publicAclAccess);
            this.publicPolicyAccess(model.publicPolicyAccess);
            this.publicAclIgnoreBehavior(model.publicAclIgnoreBehavior);
            this.publicBucketRestrictBehavior(model.publicBucketRestrictBehavior);
        }

        public final String getPublicAclAccess() {
            return this.publicAclAccess;
        }

        public final void setPublicAclAccess(String publicAclAccess) {
            this.publicAclAccess = publicAclAccess;
        }

        @Override
        public final Builder publicAclAccess(String publicAclAccess) {
            this.publicAclAccess = publicAclAccess;
            return this;
        }

        @Override
        public final Builder publicAclAccess(PublicAccessStatus publicAclAccess) {
            this.publicAclAccess(publicAclAccess == null ? null : publicAclAccess.toString());
            return this;
        }

        public final String getPublicPolicyAccess() {
            return this.publicPolicyAccess;
        }

        public final void setPublicPolicyAccess(String publicPolicyAccess) {
            this.publicPolicyAccess = publicPolicyAccess;
        }

        @Override
        public final Builder publicPolicyAccess(String publicPolicyAccess) {
            this.publicPolicyAccess = publicPolicyAccess;
            return this;
        }

        @Override
        public final Builder publicPolicyAccess(PublicAccessStatus publicPolicyAccess) {
            this.publicPolicyAccess(publicPolicyAccess == null ? null : publicPolicyAccess.toString());
            return this;
        }

        public final String getPublicAclIgnoreBehavior() {
            return this.publicAclIgnoreBehavior;
        }

        public final void setPublicAclIgnoreBehavior(String publicAclIgnoreBehavior) {
            this.publicAclIgnoreBehavior = publicAclIgnoreBehavior;
        }

        @Override
        public final Builder publicAclIgnoreBehavior(String publicAclIgnoreBehavior) {
            this.publicAclIgnoreBehavior = publicAclIgnoreBehavior;
            return this;
        }

        @Override
        public final Builder publicAclIgnoreBehavior(PublicAclIgnoreBehavior publicAclIgnoreBehavior) {
            this.publicAclIgnoreBehavior(publicAclIgnoreBehavior == null ? null : publicAclIgnoreBehavior.toString());
            return this;
        }

        public final String getPublicBucketRestrictBehavior() {
            return this.publicBucketRestrictBehavior;
        }

        public final void setPublicBucketRestrictBehavior(String publicBucketRestrictBehavior) {
            this.publicBucketRestrictBehavior = publicBucketRestrictBehavior;
        }

        @Override
        public final Builder publicBucketRestrictBehavior(String publicBucketRestrictBehavior) {
            this.publicBucketRestrictBehavior = publicBucketRestrictBehavior;
            return this;
        }

        @Override
        public final Builder publicBucketRestrictBehavior(PublicBucketRestrictBehavior publicBucketRestrictBehavior) {
            this.publicBucketRestrictBehavior(publicBucketRestrictBehavior == null ? null : publicBucketRestrictBehavior.toString());
            return this;
        }

        public PublicAccessConfiguration build() {
            return new PublicAccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicAccessConfiguration> {
        public Builder publicAclAccess(String var1);

        public Builder publicAclAccess(PublicAccessStatus var1);

        public Builder publicPolicyAccess(String var1);

        public Builder publicPolicyAccess(PublicAccessStatus var1);

        public Builder publicAclIgnoreBehavior(String var1);

        public Builder publicAclIgnoreBehavior(PublicAclIgnoreBehavior var1);

        public Builder publicBucketRestrictBehavior(String var1);

        public Builder publicBucketRestrictBehavior(PublicBucketRestrictBehavior var1);
    }
}

