/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfiguration;
import software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfigurationsCopier;
import software.amazon.awssdk.services.guardduty.model.DetectorFeature;
import software.amazon.awssdk.services.guardduty.model.FeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorFeatureConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorFeatureConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DetectorFeatureConfiguration.getter(DetectorFeatureConfiguration::nameAsString)).setter(DetectorFeatureConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DetectorFeatureConfiguration.getter(DetectorFeatureConfiguration::statusAsString)).setter(DetectorFeatureConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<DetectorAdditionalConfiguration>> ADDITIONAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalConfiguration").getter(DetectorFeatureConfiguration.getter(DetectorFeatureConfiguration::additionalConfiguration)).setter(DetectorFeatureConfiguration.setter(Builder::additionalConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectorAdditionalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, ADDITIONAL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("additionalConfiguration", ADDITIONAL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final List<DetectorAdditionalConfiguration> additionalConfiguration;

    private DetectorFeatureConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    public final DetectorFeature name() {
        return DetectorFeature.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasAdditionalConfiguration() {
        return this.additionalConfiguration != null && !(this.additionalConfiguration instanceof SdkAutoConstructList);
    }

    public final List<DetectorAdditionalConfiguration> additionalConfiguration() {
        return this.additionalConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalConfiguration() ? this.additionalConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorFeatureConfiguration)) {
            return false;
        }
        DetectorFeatureConfiguration other = (DetectorFeatureConfiguration)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAdditionalConfiguration() == other.hasAdditionalConfiguration() && Objects.equals(this.additionalConfiguration(), other.additionalConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DetectorFeatureConfiguration").add("Name", (Object)this.nameAsString()).add("Status", (Object)this.statusAsString()).add("AdditionalConfiguration", this.hasAdditionalConfiguration() ? this.additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AdditionalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.additionalConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectorFeatureConfiguration, T> g) {
        return obj -> g.apply((DetectorFeatureConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private List<DetectorAdditionalConfiguration> additionalConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorFeatureConfiguration model) {
            this.name(model.name);
            this.status(model.status);
            this.additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DetectorFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<DetectorAdditionalConfiguration.Builder> getAdditionalConfiguration() {
            List<DetectorAdditionalConfiguration.Builder> result = DetectorAdditionalConfigurationsCopier.copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(Collection<DetectorAdditionalConfiguration.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = DetectorAdditionalConfigurationsCopier.copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(Collection<DetectorAdditionalConfiguration> additionalConfiguration) {
            this.additionalConfiguration = DetectorAdditionalConfigurationsCopier.copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(DetectorAdditionalConfiguration ... additionalConfiguration) {
            this.additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(Consumer<DetectorAdditionalConfiguration.Builder> ... additionalConfiguration) {
            this.additionalConfiguration(Stream.of(additionalConfiguration).map(c -> (DetectorAdditionalConfiguration)((DetectorAdditionalConfiguration.Builder)DetectorAdditionalConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DetectorFeatureConfiguration build() {
            return new DetectorFeatureConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorFeatureConfiguration> {
        public Builder name(String var1);

        public Builder name(DetectorFeature var1);

        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder additionalConfiguration(Collection<DetectorAdditionalConfiguration> var1);

        public Builder additionalConfiguration(DetectorAdditionalConfiguration ... var1);

        public Builder additionalConfiguration(Consumer<DetectorAdditionalConfiguration.Builder> ... var1);
    }
}

