/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.MfaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Session> {
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(Session.getter(Session::uid)).setter(Session.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()}).build();
    private static final SdkField<String> MFA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MfaStatus").getter(Session.getter(Session::mfaStatusAsString)).setter(Session.setter(Builder::mfaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfaStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Session.getter(Session::createdTime)).setter(Session.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(Session.getter(Session::issuer)).setter(Session.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, MFA_STATUS_FIELD, CREATED_TIME_FIELD, ISSUER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("uid", UID_FIELD);
            this.put("mfaStatus", MFA_STATUS_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("issuer", ISSUER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String uid;
    private final String mfaStatus;
    private final Instant createdTime;
    private final String issuer;

    private Session(BuilderImpl builder) {
        this.uid = builder.uid;
        this.mfaStatus = builder.mfaStatus;
        this.createdTime = builder.createdTime;
        this.issuer = builder.issuer;
    }

    public final String uid() {
        return this.uid;
    }

    public final MfaStatus mfaStatus() {
        return MfaStatus.fromValue(this.mfaStatus);
    }

    public final String mfaStatusAsString() {
        return this.mfaStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String issuer() {
        return this.issuer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.uid(), other.uid()) && Objects.equals(this.mfaStatusAsString(), other.mfaStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.issuer(), other.issuer());
    }

    public final String toString() {
        return ToString.builder((String)"Session").add("Uid", (Object)this.uid()).add("MfaStatus", (Object)this.mfaStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("Issuer", (Object)this.issuer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "MfaStatus": {
                return Optional.ofNullable(clazz.cast(this.mfaStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uid;
        private String mfaStatus;
        private Instant createdTime;
        private String issuer;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.uid(model.uid);
            this.mfaStatus(model.mfaStatus);
            this.createdTime(model.createdTime);
            this.issuer(model.issuer);
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getMfaStatus() {
            return this.mfaStatus;
        }

        public final void setMfaStatus(String mfaStatus) {
            this.mfaStatus = mfaStatus;
        }

        @Override
        public final Builder mfaStatus(String mfaStatus) {
            this.mfaStatus = mfaStatus;
            return this;
        }

        @Override
        public final Builder mfaStatus(MfaStatus mfaStatus) {
            this.mfaStatus(mfaStatus == null ? null : mfaStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Session build() {
            return new Session(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Session> {
        public Builder uid(String var1);

        public Builder mfaStatus(String var1);

        public Builder mfaStatus(MfaStatus var1);

        public Builder createdTime(Instant var1);

        public Builder issuer(String var1);
    }
}

