/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ActorIdsCopier;
import software.amazon.awssdk.services.guardduty.model.EndpointIdsCopier;
import software.amazon.awssdk.services.guardduty.model.Indicator;
import software.amazon.awssdk.services.guardduty.model.IndicatorsCopier;
import software.amazon.awssdk.services.guardduty.model.ResourceUidsCopier;
import software.amazon.awssdk.services.guardduty.model.SignalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Signal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Signal> {
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(Signal.getter(Signal::uid)).setter(Signal.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Signal.getter(Signal::typeAsString)).setter(Signal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Signal.getter(Signal::description)).setter(Signal.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Signal.getter(Signal::name)).setter(Signal.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Signal.getter(Signal::createdAt)).setter(Signal.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Signal.getter(Signal::updatedAt)).setter(Signal.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Instant> FIRST_SEEN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FirstSeenAt").getter(Signal.getter(Signal::firstSeenAt)).setter(Signal.setter(Builder::firstSeenAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeenAt").build()}).build();
    private static final SdkField<Instant> LAST_SEEN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSeenAt").getter(Signal.getter(Signal::lastSeenAt)).setter(Signal.setter(Builder::lastSeenAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenAt").build()}).build();
    private static final SdkField<Double> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Severity").getter(Signal.getter(Signal::severity)).setter(Signal.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(Signal.getter(Signal::count)).setter(Signal.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> RESOURCE_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceUids").getter(Signal.getter(Signal::resourceUids)).setter(Signal.setter(Builder::resourceUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActorIds").getter(Signal.getter(Signal::actorIds)).setter(Signal.setter(Builder::actorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointIds").getter(Signal.getter(Signal::endpointIds)).setter(Signal.setter(Builder::endpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Indicator>> SIGNAL_INDICATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SignalIndicators").getter(Signal.getter(Signal::signalIndicators)).setter(Signal.setter(Builder::signalIndicators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalIndicators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Indicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, FIRST_SEEN_AT_FIELD, LAST_SEEN_AT_FIELD, SEVERITY_FIELD, COUNT_FIELD, RESOURCE_UIDS_FIELD, ACTOR_IDS_FIELD, ENDPOINT_IDS_FIELD, SIGNAL_INDICATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("uid", UID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("firstSeenAt", FIRST_SEEN_AT_FIELD);
            this.put("lastSeenAt", LAST_SEEN_AT_FIELD);
            this.put("severity", SEVERITY_FIELD);
            this.put("count", COUNT_FIELD);
            this.put("resourceUids", RESOURCE_UIDS_FIELD);
            this.put("actorIds", ACTOR_IDS_FIELD);
            this.put("endpointIds", ENDPOINT_IDS_FIELD);
            this.put("signalIndicators", SIGNAL_INDICATORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String uid;
    private final String type;
    private final String description;
    private final String name;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant firstSeenAt;
    private final Instant lastSeenAt;
    private final Double severity;
    private final Integer count;
    private final List<String> resourceUids;
    private final List<String> actorIds;
    private final List<String> endpointIds;
    private final List<Indicator> signalIndicators;

    private Signal(BuilderImpl builder) {
        this.uid = builder.uid;
        this.type = builder.type;
        this.description = builder.description;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.firstSeenAt = builder.firstSeenAt;
        this.lastSeenAt = builder.lastSeenAt;
        this.severity = builder.severity;
        this.count = builder.count;
        this.resourceUids = builder.resourceUids;
        this.actorIds = builder.actorIds;
        this.endpointIds = builder.endpointIds;
        this.signalIndicators = builder.signalIndicators;
    }

    public final String uid() {
        return this.uid;
    }

    public final SignalType type() {
        return SignalType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant firstSeenAt() {
        return this.firstSeenAt;
    }

    public final Instant lastSeenAt() {
        return this.lastSeenAt;
    }

    public final Double severity() {
        return this.severity;
    }

    public final Integer count() {
        return this.count;
    }

    public final boolean hasResourceUids() {
        return this.resourceUids != null && !(this.resourceUids instanceof SdkAutoConstructList);
    }

    public final List<String> resourceUids() {
        return this.resourceUids;
    }

    public final boolean hasActorIds() {
        return this.actorIds != null && !(this.actorIds instanceof SdkAutoConstructList);
    }

    public final List<String> actorIds() {
        return this.actorIds;
    }

    public final boolean hasEndpointIds() {
        return this.endpointIds != null && !(this.endpointIds instanceof SdkAutoConstructList);
    }

    public final List<String> endpointIds() {
        return this.endpointIds;
    }

    public final boolean hasSignalIndicators() {
        return this.signalIndicators != null && !(this.signalIndicators instanceof SdkAutoConstructList);
    }

    public final List<Indicator> signalIndicators() {
        return this.signalIndicators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeenAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeenAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceUids() ? this.resourceUids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActorIds() ? this.actorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointIds() ? this.endpointIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalIndicators() ? this.signalIndicators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signal)) {
            return false;
        }
        Signal other = (Signal)obj;
        return Objects.equals(this.uid(), other.uid()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.firstSeenAt(), other.firstSeenAt()) && Objects.equals(this.lastSeenAt(), other.lastSeenAt()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.count(), other.count()) && this.hasResourceUids() == other.hasResourceUids() && Objects.equals(this.resourceUids(), other.resourceUids()) && this.hasActorIds() == other.hasActorIds() && Objects.equals(this.actorIds(), other.actorIds()) && this.hasEndpointIds() == other.hasEndpointIds() && Objects.equals(this.endpointIds(), other.endpointIds()) && this.hasSignalIndicators() == other.hasSignalIndicators() && Objects.equals(this.signalIndicators(), other.signalIndicators());
    }

    public final String toString() {
        return ToString.builder((String)"Signal").add("Uid", (Object)this.uid()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("FirstSeenAt", (Object)this.firstSeenAt()).add("LastSeenAt", (Object)this.lastSeenAt()).add("Severity", (Object)this.severity()).add("Count", (Object)this.count()).add("ResourceUids", this.hasResourceUids() ? this.resourceUids() : null).add("ActorIds", this.hasActorIds() ? this.actorIds() : null).add("EndpointIds", this.hasEndpointIds() ? this.endpointIds() : null).add("SignalIndicators", this.hasSignalIndicators() ? this.signalIndicators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "FirstSeenAt": {
                return Optional.ofNullable(clazz.cast(this.firstSeenAt()));
            }
            case "LastSeenAt": {
                return Optional.ofNullable(clazz.cast(this.lastSeenAt()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "ResourceUids": {
                return Optional.ofNullable(clazz.cast(this.resourceUids()));
            }
            case "ActorIds": {
                return Optional.ofNullable(clazz.cast(this.actorIds()));
            }
            case "EndpointIds": {
                return Optional.ofNullable(clazz.cast(this.endpointIds()));
            }
            case "SignalIndicators": {
                return Optional.ofNullable(clazz.cast(this.signalIndicators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Signal, T> g) {
        return obj -> g.apply((Signal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uid;
        private String type;
        private String description;
        private String name;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant firstSeenAt;
        private Instant lastSeenAt;
        private Double severity;
        private Integer count;
        private List<String> resourceUids = DefaultSdkAutoConstructList.getInstance();
        private List<String> actorIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> endpointIds = DefaultSdkAutoConstructList.getInstance();
        private List<Indicator> signalIndicators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Signal model) {
            this.uid(model.uid);
            this.type(model.type);
            this.description(model.description);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.firstSeenAt(model.firstSeenAt);
            this.lastSeenAt(model.lastSeenAt);
            this.severity(model.severity);
            this.count(model.count);
            this.resourceUids(model.resourceUids);
            this.actorIds(model.actorIds);
            this.endpointIds(model.endpointIds);
            this.signalIndicators(model.signalIndicators);
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SignalType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getFirstSeenAt() {
            return this.firstSeenAt;
        }

        public final void setFirstSeenAt(Instant firstSeenAt) {
            this.firstSeenAt = firstSeenAt;
        }

        @Override
        public final Builder firstSeenAt(Instant firstSeenAt) {
            this.firstSeenAt = firstSeenAt;
            return this;
        }

        public final Instant getLastSeenAt() {
            return this.lastSeenAt;
        }

        public final void setLastSeenAt(Instant lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
        }

        @Override
        public final Builder lastSeenAt(Instant lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public final Double getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getResourceUids() {
            if (this.resourceUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceUids;
        }

        public final void setResourceUids(Collection<String> resourceUids) {
            this.resourceUids = ResourceUidsCopier.copy(resourceUids);
        }

        @Override
        public final Builder resourceUids(Collection<String> resourceUids) {
            this.resourceUids = ResourceUidsCopier.copy(resourceUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUids(String ... resourceUids) {
            this.resourceUids(Arrays.asList(resourceUids));
            return this;
        }

        public final Collection<String> getActorIds() {
            if (this.actorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actorIds;
        }

        public final void setActorIds(Collection<String> actorIds) {
            this.actorIds = ActorIdsCopier.copy(actorIds);
        }

        @Override
        public final Builder actorIds(Collection<String> actorIds) {
            this.actorIds = ActorIdsCopier.copy(actorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actorIds(String ... actorIds) {
            this.actorIds(Arrays.asList(actorIds));
            return this;
        }

        public final Collection<String> getEndpointIds() {
            if (this.endpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointIds;
        }

        public final void setEndpointIds(Collection<String> endpointIds) {
            this.endpointIds = EndpointIdsCopier.copy(endpointIds);
        }

        @Override
        public final Builder endpointIds(Collection<String> endpointIds) {
            this.endpointIds = EndpointIdsCopier.copy(endpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointIds(String ... endpointIds) {
            this.endpointIds(Arrays.asList(endpointIds));
            return this;
        }

        public final List<Indicator.Builder> getSignalIndicators() {
            List<Indicator.Builder> result = IndicatorsCopier.copyToBuilder(this.signalIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalIndicators(Collection<Indicator.BuilderImpl> signalIndicators) {
            this.signalIndicators = IndicatorsCopier.copyFromBuilder(signalIndicators);
        }

        @Override
        public final Builder signalIndicators(Collection<Indicator> signalIndicators) {
            this.signalIndicators = IndicatorsCopier.copy(signalIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalIndicators(Indicator ... signalIndicators) {
            this.signalIndicators(Arrays.asList(signalIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalIndicators(Consumer<Indicator.Builder> ... signalIndicators) {
            this.signalIndicators(Stream.of(signalIndicators).map(c -> (Indicator)((Indicator.Builder)Indicator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Signal build() {
            return new Signal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Signal> {
        public Builder uid(String var1);

        public Builder type(String var1);

        public Builder type(SignalType var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder firstSeenAt(Instant var1);

        public Builder lastSeenAt(Instant var1);

        public Builder severity(Double var1);

        public Builder count(Integer var1);

        public Builder resourceUids(Collection<String> var1);

        public Builder resourceUids(String ... var1);

        public Builder actorIds(Collection<String> var1);

        public Builder actorIds(String ... var1);

        public Builder endpointIds(Collection<String> var1);

        public Builder endpointIds(String ... var1);

        public Builder signalIndicators(Collection<Indicator> var1);

        public Builder signalIndicators(Indicator ... var1);

        public Builder signalIndicators(Consumer<Indicator.Builder> ... var1);
    }
}

