/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoginAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoginAttribute> {
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(LoginAttribute.getter(LoginAttribute::user)).setter(LoginAttribute.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Application").getter(LoginAttribute.getter(LoginAttribute::application)).setter(LoginAttribute.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<Integer> FAILED_LOGIN_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedLoginAttempts").getter(LoginAttribute.getter(LoginAttribute::failedLoginAttempts)).setter(LoginAttribute.setter(Builder::failedLoginAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedLoginAttempts").build()}).build();
    private static final SdkField<Integer> SUCCESSFUL_LOGIN_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessfulLoginAttempts").getter(LoginAttribute.getter(LoginAttribute::successfulLoginAttempts)).setter(LoginAttribute.setter(Builder::successfulLoginAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulLoginAttempts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, APPLICATION_FIELD, FAILED_LOGIN_ATTEMPTS_FIELD, SUCCESSFUL_LOGIN_ATTEMPTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("user", USER_FIELD);
            this.put("application", APPLICATION_FIELD);
            this.put("failedLoginAttempts", FAILED_LOGIN_ATTEMPTS_FIELD);
            this.put("successfulLoginAttempts", SUCCESSFUL_LOGIN_ATTEMPTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String user;
    private final String application;
    private final Integer failedLoginAttempts;
    private final Integer successfulLoginAttempts;

    private LoginAttribute(BuilderImpl builder) {
        this.user = builder.user;
        this.application = builder.application;
        this.failedLoginAttempts = builder.failedLoginAttempts;
        this.successfulLoginAttempts = builder.successfulLoginAttempts;
    }

    public final String user() {
        return this.user;
    }

    public final String application() {
        return this.application;
    }

    public final Integer failedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public final Integer successfulLoginAttempts() {
        return this.successfulLoginAttempts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedLoginAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulLoginAttempts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoginAttribute)) {
            return false;
        }
        LoginAttribute other = (LoginAttribute)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.application(), other.application()) && Objects.equals(this.failedLoginAttempts(), other.failedLoginAttempts()) && Objects.equals(this.successfulLoginAttempts(), other.successfulLoginAttempts());
    }

    public final String toString() {
        return ToString.builder((String)"LoginAttribute").add("User", (Object)this.user()).add("Application", (Object)this.application()).add("FailedLoginAttempts", (Object)this.failedLoginAttempts()).add("SuccessfulLoginAttempts", (Object)this.successfulLoginAttempts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "FailedLoginAttempts": {
                return Optional.ofNullable(clazz.cast(this.failedLoginAttempts()));
            }
            case "SuccessfulLoginAttempts": {
                return Optional.ofNullable(clazz.cast(this.successfulLoginAttempts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LoginAttribute, T> g) {
        return obj -> g.apply((LoginAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String user;
        private String application;
        private Integer failedLoginAttempts;
        private Integer successfulLoginAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginAttribute model) {
            this.user(model.user);
            this.application(model.application);
            this.failedLoginAttempts(model.failedLoginAttempts);
            this.successfulLoginAttempts(model.successfulLoginAttempts);
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final Integer getFailedLoginAttempts() {
            return this.failedLoginAttempts;
        }

        public final void setFailedLoginAttempts(Integer failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
        }

        @Override
        public final Builder failedLoginAttempts(Integer failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
            return this;
        }

        public final Integer getSuccessfulLoginAttempts() {
            return this.successfulLoginAttempts;
        }

        public final void setSuccessfulLoginAttempts(Integer successfulLoginAttempts) {
            this.successfulLoginAttempts = successfulLoginAttempts;
        }

        @Override
        public final Builder successfulLoginAttempts(Integer successfulLoginAttempts) {
            this.successfulLoginAttempts = successfulLoginAttempts;
            return this;
        }

        public LoginAttribute build() {
            return new LoginAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoginAttribute> {
        public Builder user(String var1);

        public Builder application(String var1);

        public Builder failedLoginAttempts(Integer var1);

        public Builder successfulLoginAttempts(Integer var1);
    }
}

