/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ScanDetections;
import software.amazon.awssdk.services.guardduty.model.ScanType;
import software.amazon.awssdk.services.guardduty.model.SourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsVolumeScanDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsVolumeScanDetails> {
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanId").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::scanId)).setter(EbsVolumeScanDetails.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()}).build();
    private static final SdkField<Instant> SCAN_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanStartedAt").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::scanStartedAt)).setter(EbsVolumeScanDetails.setter(Builder::scanStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStartedAt").build()}).build();
    private static final SdkField<Instant> SCAN_COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanCompletedAt").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::scanCompletedAt)).setter(EbsVolumeScanDetails.setter(Builder::scanCompletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanCompletedAt").build()}).build();
    private static final SdkField<String> TRIGGER_FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerFindingId").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::triggerFindingId)).setter(EbsVolumeScanDetails.setter(Builder::triggerFindingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerFindingId").build()}).build();
    private static final SdkField<List<String>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::sources)).setter(EbsVolumeScanDetails.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScanDetections> SCAN_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanDetections").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::scanDetections)).setter(EbsVolumeScanDetails.setter(Builder::scanDetections)).constructor(ScanDetections::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDetections").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(EbsVolumeScanDetails.getter(EbsVolumeScanDetails::scanTypeAsString)).setter(EbsVolumeScanDetails.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ID_FIELD, SCAN_STARTED_AT_FIELD, SCAN_COMPLETED_AT_FIELD, TRIGGER_FINDING_ID_FIELD, SOURCES_FIELD, SCAN_DETECTIONS_FIELD, SCAN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scanId", SCAN_ID_FIELD);
            this.put("scanStartedAt", SCAN_STARTED_AT_FIELD);
            this.put("scanCompletedAt", SCAN_COMPLETED_AT_FIELD);
            this.put("triggerFindingId", TRIGGER_FINDING_ID_FIELD);
            this.put("sources", SOURCES_FIELD);
            this.put("scanDetections", SCAN_DETECTIONS_FIELD);
            this.put("scanType", SCAN_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String scanId;
    private final Instant scanStartedAt;
    private final Instant scanCompletedAt;
    private final String triggerFindingId;
    private final List<String> sources;
    private final ScanDetections scanDetections;
    private final String scanType;

    private EbsVolumeScanDetails(BuilderImpl builder) {
        this.scanId = builder.scanId;
        this.scanStartedAt = builder.scanStartedAt;
        this.scanCompletedAt = builder.scanCompletedAt;
        this.triggerFindingId = builder.triggerFindingId;
        this.sources = builder.sources;
        this.scanDetections = builder.scanDetections;
        this.scanType = builder.scanType;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final Instant scanStartedAt() {
        return this.scanStartedAt;
    }

    public final Instant scanCompletedAt() {
        return this.scanCompletedAt;
    }

    public final String triggerFindingId() {
        return this.triggerFindingId;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<String> sources() {
        return this.sources;
    }

    public final ScanDetections scanDetections() {
        return this.scanDetections;
    }

    public final ScanType scanType() {
        return ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanCompletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerFindingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanDetections());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolumeScanDetails)) {
            return false;
        }
        EbsVolumeScanDetails other = (EbsVolumeScanDetails)obj;
        return Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.scanStartedAt(), other.scanStartedAt()) && Objects.equals(this.scanCompletedAt(), other.scanCompletedAt()) && Objects.equals(this.triggerFindingId(), other.triggerFindingId()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.scanDetections(), other.scanDetections()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EbsVolumeScanDetails").add("ScanId", (Object)this.scanId()).add("ScanStartedAt", (Object)this.scanStartedAt()).add("ScanCompletedAt", (Object)this.scanCompletedAt()).add("TriggerFindingId", (Object)this.triggerFindingId()).add("Sources", this.hasSources() ? this.sources() : null).add("ScanDetections", (Object)this.scanDetections()).add("ScanType", (Object)this.scanTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "ScanStartedAt": {
                return Optional.ofNullable(clazz.cast(this.scanStartedAt()));
            }
            case "ScanCompletedAt": {
                return Optional.ofNullable(clazz.cast(this.scanCompletedAt()));
            }
            case "TriggerFindingId": {
                return Optional.ofNullable(clazz.cast(this.triggerFindingId()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "ScanDetections": {
                return Optional.ofNullable(clazz.cast(this.scanDetections()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EbsVolumeScanDetails, T> g) {
        return obj -> g.apply((EbsVolumeScanDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scanId;
        private Instant scanStartedAt;
        private Instant scanCompletedAt;
        private String triggerFindingId;
        private List<String> sources = DefaultSdkAutoConstructList.getInstance();
        private ScanDetections scanDetections;
        private String scanType;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolumeScanDetails model) {
            this.scanId(model.scanId);
            this.scanStartedAt(model.scanStartedAt);
            this.scanCompletedAt(model.scanCompletedAt);
            this.triggerFindingId(model.triggerFindingId);
            this.sources(model.sources);
            this.scanDetections(model.scanDetections);
            this.scanType(model.scanType);
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final Instant getScanStartedAt() {
            return this.scanStartedAt;
        }

        public final void setScanStartedAt(Instant scanStartedAt) {
            this.scanStartedAt = scanStartedAt;
        }

        @Override
        public final Builder scanStartedAt(Instant scanStartedAt) {
            this.scanStartedAt = scanStartedAt;
            return this;
        }

        public final Instant getScanCompletedAt() {
            return this.scanCompletedAt;
        }

        public final void setScanCompletedAt(Instant scanCompletedAt) {
            this.scanCompletedAt = scanCompletedAt;
        }

        @Override
        public final Builder scanCompletedAt(Instant scanCompletedAt) {
            this.scanCompletedAt = scanCompletedAt;
            return this;
        }

        public final String getTriggerFindingId() {
            return this.triggerFindingId;
        }

        public final void setTriggerFindingId(String triggerFindingId) {
            this.triggerFindingId = triggerFindingId;
        }

        @Override
        public final Builder triggerFindingId(String triggerFindingId) {
            this.triggerFindingId = triggerFindingId;
            return this;
        }

        public final Collection<String> getSources() {
            if (this.sources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = SourcesCopier.copy(sources);
        }

        @Override
        public final Builder sources(Collection<String> sources) {
            this.sources = SourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(String ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        public final ScanDetections.Builder getScanDetections() {
            return this.scanDetections != null ? this.scanDetections.toBuilder() : null;
        }

        public final void setScanDetections(ScanDetections.BuilderImpl scanDetections) {
            this.scanDetections = scanDetections != null ? scanDetections.build() : null;
        }

        @Override
        public final Builder scanDetections(ScanDetections scanDetections) {
            this.scanDetections = scanDetections;
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public EbsVolumeScanDetails build() {
            return new EbsVolumeScanDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsVolumeScanDetails> {
        public Builder scanId(String var1);

        public Builder scanStartedAt(Instant var1);

        public Builder scanCompletedAt(Instant var1);

        public Builder triggerFindingId(String var1);

        public Builder sources(Collection<String> var1);

        public Builder sources(String ... var1);

        public Builder scanDetections(ScanDetections var1);

        default public Builder scanDetections(Consumer<ScanDetections.Builder> scanDetections) {
            return this.scanDetections((ScanDetections)((ScanDetections.Builder)ScanDetections.builder().applyMutation(scanDetections)).build());
        }

        public Builder scanType(String var1);

        public Builder scanType(ScanType var1);
    }
}

