/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.UsageAccountResult;
import software.amazon.awssdk.services.guardduty.model.UsageAccountResultListCopier;
import software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult;
import software.amazon.awssdk.services.guardduty.model.UsageDataSourceResultListCopier;
import software.amazon.awssdk.services.guardduty.model.UsageFeatureResult;
import software.amazon.awssdk.services.guardduty.model.UsageFeatureResultListCopier;
import software.amazon.awssdk.services.guardduty.model.UsageResourceResult;
import software.amazon.awssdk.services.guardduty.model.UsageResourceResultListCopier;
import software.amazon.awssdk.services.guardduty.model.UsageTopAccountsResult;
import software.amazon.awssdk.services.guardduty.model.UsageTopAccountsResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageStatistics> {
    private static final SdkField<List<UsageAccountResult>> SUM_BY_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByAccount").getter(UsageStatistics.getter(UsageStatistics::sumByAccount)).setter(UsageStatistics.setter(Builder::sumByAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByAccount").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageAccountResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageTopAccountsResult>> TOP_ACCOUNTS_BY_FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopAccountsByFeature").getter(UsageStatistics.getter(UsageStatistics::topAccountsByFeature)).setter(UsageStatistics.setter(Builder::topAccountsByFeature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topAccountsByFeature").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageTopAccountsResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageDataSourceResult>> SUM_BY_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByDataSource").getter(UsageStatistics.getter(UsageStatistics::sumByDataSource)).setter(UsageStatistics.setter(Builder::sumByDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByDataSource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageDataSourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageResourceResult>> SUM_BY_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByResource").getter(UsageStatistics.getter(UsageStatistics::sumByResource)).setter(UsageStatistics.setter(Builder::sumByResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByResource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageResourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageResourceResult>> TOP_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopResources").getter(UsageStatistics.getter(UsageStatistics::topResources)).setter(UsageStatistics.setter(Builder::topResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageResourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageFeatureResult>> SUM_BY_FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByFeature").getter(UsageStatistics.getter(UsageStatistics::sumByFeature)).setter(UsageStatistics.setter(Builder::sumByFeature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByFeature").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageFeatureResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUM_BY_ACCOUNT_FIELD, TOP_ACCOUNTS_BY_FEATURE_FIELD, SUM_BY_DATA_SOURCE_FIELD, SUM_BY_RESOURCE_FIELD, TOP_RESOURCES_FIELD, SUM_BY_FEATURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sumByAccount", SUM_BY_ACCOUNT_FIELD);
            this.put("topAccountsByFeature", TOP_ACCOUNTS_BY_FEATURE_FIELD);
            this.put("sumByDataSource", SUM_BY_DATA_SOURCE_FIELD);
            this.put("sumByResource", SUM_BY_RESOURCE_FIELD);
            this.put("topResources", TOP_RESOURCES_FIELD);
            this.put("sumByFeature", SUM_BY_FEATURE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<UsageAccountResult> sumByAccount;
    private final List<UsageTopAccountsResult> topAccountsByFeature;
    private final List<UsageDataSourceResult> sumByDataSource;
    private final List<UsageResourceResult> sumByResource;
    private final List<UsageResourceResult> topResources;
    private final List<UsageFeatureResult> sumByFeature;

    private UsageStatistics(BuilderImpl builder) {
        this.sumByAccount = builder.sumByAccount;
        this.topAccountsByFeature = builder.topAccountsByFeature;
        this.sumByDataSource = builder.sumByDataSource;
        this.sumByResource = builder.sumByResource;
        this.topResources = builder.topResources;
        this.sumByFeature = builder.sumByFeature;
    }

    public final boolean hasSumByAccount() {
        return this.sumByAccount != null && !(this.sumByAccount instanceof SdkAutoConstructList);
    }

    public final List<UsageAccountResult> sumByAccount() {
        return this.sumByAccount;
    }

    public final boolean hasTopAccountsByFeature() {
        return this.topAccountsByFeature != null && !(this.topAccountsByFeature instanceof SdkAutoConstructList);
    }

    public final List<UsageTopAccountsResult> topAccountsByFeature() {
        return this.topAccountsByFeature;
    }

    public final boolean hasSumByDataSource() {
        return this.sumByDataSource != null && !(this.sumByDataSource instanceof SdkAutoConstructList);
    }

    public final List<UsageDataSourceResult> sumByDataSource() {
        return this.sumByDataSource;
    }

    public final boolean hasSumByResource() {
        return this.sumByResource != null && !(this.sumByResource instanceof SdkAutoConstructList);
    }

    public final List<UsageResourceResult> sumByResource() {
        return this.sumByResource;
    }

    public final boolean hasTopResources() {
        return this.topResources != null && !(this.topResources instanceof SdkAutoConstructList);
    }

    public final List<UsageResourceResult> topResources() {
        return this.topResources;
    }

    public final boolean hasSumByFeature() {
        return this.sumByFeature != null && !(this.sumByFeature instanceof SdkAutoConstructList);
    }

    public final List<UsageFeatureResult> sumByFeature() {
        return this.sumByFeature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByAccount() ? this.sumByAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopAccountsByFeature() ? this.topAccountsByFeature() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByDataSource() ? this.sumByDataSource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByResource() ? this.sumByResource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopResources() ? this.topResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByFeature() ? this.sumByFeature() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageStatistics)) {
            return false;
        }
        UsageStatistics other = (UsageStatistics)obj;
        return this.hasSumByAccount() == other.hasSumByAccount() && Objects.equals(this.sumByAccount(), other.sumByAccount()) && this.hasTopAccountsByFeature() == other.hasTopAccountsByFeature() && Objects.equals(this.topAccountsByFeature(), other.topAccountsByFeature()) && this.hasSumByDataSource() == other.hasSumByDataSource() && Objects.equals(this.sumByDataSource(), other.sumByDataSource()) && this.hasSumByResource() == other.hasSumByResource() && Objects.equals(this.sumByResource(), other.sumByResource()) && this.hasTopResources() == other.hasTopResources() && Objects.equals(this.topResources(), other.topResources()) && this.hasSumByFeature() == other.hasSumByFeature() && Objects.equals(this.sumByFeature(), other.sumByFeature());
    }

    public final String toString() {
        return ToString.builder((String)"UsageStatistics").add("SumByAccount", this.hasSumByAccount() ? this.sumByAccount() : null).add("TopAccountsByFeature", this.hasTopAccountsByFeature() ? this.topAccountsByFeature() : null).add("SumByDataSource", this.hasSumByDataSource() ? this.sumByDataSource() : null).add("SumByResource", this.hasSumByResource() ? this.sumByResource() : null).add("TopResources", this.hasTopResources() ? this.topResources() : null).add("SumByFeature", this.hasSumByFeature() ? this.sumByFeature() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SumByAccount": {
                return Optional.ofNullable(clazz.cast(this.sumByAccount()));
            }
            case "TopAccountsByFeature": {
                return Optional.ofNullable(clazz.cast(this.topAccountsByFeature()));
            }
            case "SumByDataSource": {
                return Optional.ofNullable(clazz.cast(this.sumByDataSource()));
            }
            case "SumByResource": {
                return Optional.ofNullable(clazz.cast(this.sumByResource()));
            }
            case "TopResources": {
                return Optional.ofNullable(clazz.cast(this.topResources()));
            }
            case "SumByFeature": {
                return Optional.ofNullable(clazz.cast(this.sumByFeature()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UsageStatistics, T> g) {
        return obj -> g.apply((UsageStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UsageAccountResult> sumByAccount = DefaultSdkAutoConstructList.getInstance();
        private List<UsageTopAccountsResult> topAccountsByFeature = DefaultSdkAutoConstructList.getInstance();
        private List<UsageDataSourceResult> sumByDataSource = DefaultSdkAutoConstructList.getInstance();
        private List<UsageResourceResult> sumByResource = DefaultSdkAutoConstructList.getInstance();
        private List<UsageResourceResult> topResources = DefaultSdkAutoConstructList.getInstance();
        private List<UsageFeatureResult> sumByFeature = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageStatistics model) {
            this.sumByAccount(model.sumByAccount);
            this.topAccountsByFeature(model.topAccountsByFeature);
            this.sumByDataSource(model.sumByDataSource);
            this.sumByResource(model.sumByResource);
            this.topResources(model.topResources);
            this.sumByFeature(model.sumByFeature);
        }

        public final List<UsageAccountResult.Builder> getSumByAccount() {
            List<UsageAccountResult.Builder> result = UsageAccountResultListCopier.copyToBuilder(this.sumByAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByAccount(Collection<UsageAccountResult.BuilderImpl> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copyFromBuilder(sumByAccount);
        }

        @Override
        public final Builder sumByAccount(Collection<UsageAccountResult> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copy(sumByAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(UsageAccountResult ... sumByAccount) {
            this.sumByAccount(Arrays.asList(sumByAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(Consumer<UsageAccountResult.Builder> ... sumByAccount) {
            this.sumByAccount(Stream.of(sumByAccount).map(c -> (UsageAccountResult)((UsageAccountResult.Builder)UsageAccountResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UsageTopAccountsResult.Builder> getTopAccountsByFeature() {
            List<UsageTopAccountsResult.Builder> result = UsageTopAccountsResultListCopier.copyToBuilder(this.topAccountsByFeature);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopAccountsByFeature(Collection<UsageTopAccountsResult.BuilderImpl> topAccountsByFeature) {
            this.topAccountsByFeature = UsageTopAccountsResultListCopier.copyFromBuilder(topAccountsByFeature);
        }

        @Override
        public final Builder topAccountsByFeature(Collection<UsageTopAccountsResult> topAccountsByFeature) {
            this.topAccountsByFeature = UsageTopAccountsResultListCopier.copy(topAccountsByFeature);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccountsByFeature(UsageTopAccountsResult ... topAccountsByFeature) {
            this.topAccountsByFeature(Arrays.asList(topAccountsByFeature));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccountsByFeature(Consumer<UsageTopAccountsResult.Builder> ... topAccountsByFeature) {
            this.topAccountsByFeature(Stream.of(topAccountsByFeature).map(c -> (UsageTopAccountsResult)((UsageTopAccountsResult.Builder)UsageTopAccountsResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UsageDataSourceResult.Builder> getSumByDataSource() {
            List<UsageDataSourceResult.Builder> result = UsageDataSourceResultListCopier.copyToBuilder(this.sumByDataSource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByDataSource(Collection<UsageDataSourceResult.BuilderImpl> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copyFromBuilder(sumByDataSource);
        }

        @Override
        public final Builder sumByDataSource(Collection<UsageDataSourceResult> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copy(sumByDataSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(UsageDataSourceResult ... sumByDataSource) {
            this.sumByDataSource(Arrays.asList(sumByDataSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder> ... sumByDataSource) {
            this.sumByDataSource(Stream.of(sumByDataSource).map(c -> (UsageDataSourceResult)((UsageDataSourceResult.Builder)UsageDataSourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UsageResourceResult.Builder> getSumByResource() {
            List<UsageResourceResult.Builder> result = UsageResourceResultListCopier.copyToBuilder(this.sumByResource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByResource(Collection<UsageResourceResult.BuilderImpl> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copyFromBuilder(sumByResource);
        }

        @Override
        public final Builder sumByResource(Collection<UsageResourceResult> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copy(sumByResource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(UsageResourceResult ... sumByResource) {
            this.sumByResource(Arrays.asList(sumByResource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(Consumer<UsageResourceResult.Builder> ... sumByResource) {
            this.sumByResource(Stream.of(sumByResource).map(c -> (UsageResourceResult)((UsageResourceResult.Builder)UsageResourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UsageResourceResult.Builder> getTopResources() {
            List<UsageResourceResult.Builder> result = UsageResourceResultListCopier.copyToBuilder(this.topResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopResources(Collection<UsageResourceResult.BuilderImpl> topResources) {
            this.topResources = UsageResourceResultListCopier.copyFromBuilder(topResources);
        }

        @Override
        public final Builder topResources(Collection<UsageResourceResult> topResources) {
            this.topResources = UsageResourceResultListCopier.copy(topResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(UsageResourceResult ... topResources) {
            this.topResources(Arrays.asList(topResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(Consumer<UsageResourceResult.Builder> ... topResources) {
            this.topResources(Stream.of(topResources).map(c -> (UsageResourceResult)((UsageResourceResult.Builder)UsageResourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UsageFeatureResult.Builder> getSumByFeature() {
            List<UsageFeatureResult.Builder> result = UsageFeatureResultListCopier.copyToBuilder(this.sumByFeature);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByFeature(Collection<UsageFeatureResult.BuilderImpl> sumByFeature) {
            this.sumByFeature = UsageFeatureResultListCopier.copyFromBuilder(sumByFeature);
        }

        @Override
        public final Builder sumByFeature(Collection<UsageFeatureResult> sumByFeature) {
            this.sumByFeature = UsageFeatureResultListCopier.copy(sumByFeature);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByFeature(UsageFeatureResult ... sumByFeature) {
            this.sumByFeature(Arrays.asList(sumByFeature));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByFeature(Consumer<UsageFeatureResult.Builder> ... sumByFeature) {
            this.sumByFeature(Stream.of(sumByFeature).map(c -> (UsageFeatureResult)((UsageFeatureResult.Builder)UsageFeatureResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UsageStatistics build() {
            return new UsageStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageStatistics> {
        public Builder sumByAccount(Collection<UsageAccountResult> var1);

        public Builder sumByAccount(UsageAccountResult ... var1);

        public Builder sumByAccount(Consumer<UsageAccountResult.Builder> ... var1);

        public Builder topAccountsByFeature(Collection<UsageTopAccountsResult> var1);

        public Builder topAccountsByFeature(UsageTopAccountsResult ... var1);

        public Builder topAccountsByFeature(Consumer<UsageTopAccountsResult.Builder> ... var1);

        public Builder sumByDataSource(Collection<UsageDataSourceResult> var1);

        public Builder sumByDataSource(UsageDataSourceResult ... var1);

        public Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder> ... var1);

        public Builder sumByResource(Collection<UsageResourceResult> var1);

        public Builder sumByResource(UsageResourceResult ... var1);

        public Builder sumByResource(Consumer<UsageResourceResult.Builder> ... var1);

        public Builder topResources(Collection<UsageResourceResult> var1);

        public Builder topResources(UsageResourceResult ... var1);

        public Builder topResources(Consumer<UsageResourceResult.Builder> ... var1);

        public Builder sumByFeature(Collection<UsageFeatureResult> var1);

        public Builder sumByFeature(UsageFeatureResult ... var1);

        public Builder sumByFeature(Consumer<UsageFeatureResult.Builder> ... var1);
    }
}

