/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.CoverageFilterCriteria;
import software.amazon.awssdk.services.guardduty.model.CoverageStatisticsType;
import software.amazon.awssdk.services.guardduty.model.CoverageStatisticsTypeListCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCoverageStatisticsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, GetCoverageStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(GetCoverageStatisticsRequest.getter(GetCoverageStatisticsRequest::detectorId)).setter(GetCoverageStatisticsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<CoverageFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(GetCoverageStatisticsRequest.getter(GetCoverageStatisticsRequest::filterCriteria)).setter(GetCoverageStatisticsRequest.setter(Builder::filterCriteria)).constructor(CoverageFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<List<String>> STATISTICS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatisticsType").getter(GetCoverageStatisticsRequest.getter(GetCoverageStatisticsRequest::statisticsTypeAsStrings)).setter(GetCoverageStatisticsRequest.setter(Builder::statisticsTypeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statisticsType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, FILTER_CRITERIA_FIELD, STATISTICS_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("detectorId", DETECTOR_ID_FIELD);
            this.put("filterCriteria", FILTER_CRITERIA_FIELD);
            this.put("statisticsType", STATISTICS_TYPE_FIELD);
        }
    });
    private final String detectorId;
    private final CoverageFilterCriteria filterCriteria;
    private final List<String> statisticsType;

    private GetCoverageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.filterCriteria = builder.filterCriteria;
        this.statisticsType = builder.statisticsType;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final CoverageFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final List<CoverageStatisticsType> statisticsType() {
        return CoverageStatisticsTypeListCopier.copyStringToEnum(this.statisticsType);
    }

    public final boolean hasStatisticsType() {
        return this.statisticsType != null && !(this.statisticsType instanceof SdkAutoConstructList);
    }

    public final List<String> statisticsTypeAsStrings() {
        return this.statisticsType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatisticsType() ? this.statisticsTypeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoverageStatisticsRequest)) {
            return false;
        }
        GetCoverageStatisticsRequest other = (GetCoverageStatisticsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && this.hasStatisticsType() == other.hasStatisticsType() && Objects.equals(this.statisticsTypeAsStrings(), other.statisticsTypeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetCoverageStatisticsRequest").add("DetectorId", (Object)this.detectorId()).add("FilterCriteria", (Object)this.filterCriteria()).add("StatisticsType", this.hasStatisticsType() ? this.statisticsTypeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "StatisticsType": {
                return Optional.ofNullable(clazz.cast(this.statisticsTypeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCoverageStatisticsRequest, T> g) {
        return obj -> g.apply((GetCoverageStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private CoverageFilterCriteria filterCriteria;
        private List<String> statisticsType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoverageStatisticsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.filterCriteria(model.filterCriteria);
            this.statisticsTypeWithStrings(model.statisticsType);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final CoverageFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CoverageFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CoverageFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Collection<String> getStatisticsType() {
            if (this.statisticsType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statisticsType;
        }

        public final void setStatisticsType(Collection<String> statisticsType) {
            this.statisticsType = CoverageStatisticsTypeListCopier.copy(statisticsType);
        }

        @Override
        public final Builder statisticsTypeWithStrings(Collection<String> statisticsType) {
            this.statisticsType = CoverageStatisticsTypeListCopier.copy(statisticsType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsTypeWithStrings(String ... statisticsType) {
            this.statisticsTypeWithStrings(Arrays.asList(statisticsType));
            return this;
        }

        @Override
        public final Builder statisticsType(Collection<CoverageStatisticsType> statisticsType) {
            this.statisticsType = CoverageStatisticsTypeListCopier.copyEnumToString(statisticsType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsType(CoverageStatisticsType ... statisticsType) {
            this.statisticsType(Arrays.asList(statisticsType));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCoverageStatisticsRequest build() {
            return new GetCoverageStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCoverageStatisticsRequest> {
        public Builder detectorId(String var1);

        public Builder filterCriteria(CoverageFilterCriteria var1);

        default public Builder filterCriteria(Consumer<CoverageFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((CoverageFilterCriteria)((CoverageFilterCriteria.Builder)CoverageFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder statisticsTypeWithStrings(Collection<String> var1);

        public Builder statisticsTypeWithStrings(String ... var1);

        public Builder statisticsType(Collection<CoverageStatisticsType> var1);

        public Builder statisticsType(CoverageStatisticsType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

