/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.OrgFeature;
import software.amazon.awssdk.services.guardduty.model.OrgFeatureStatus;
import software.amazon.awssdk.services.guardduty.model.OrganizationAdditionalConfigurationResult;
import software.amazon.awssdk.services.guardduty.model.OrganizationAdditionalConfigurationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationFeatureConfigurationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationFeatureConfigurationResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OrganizationFeatureConfigurationResult.getter(OrganizationFeatureConfigurationResult::nameAsString)).setter(OrganizationFeatureConfigurationResult.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEnable").getter(OrganizationFeatureConfigurationResult.getter(OrganizationFeatureConfigurationResult::autoEnableAsString)).setter(OrganizationFeatureConfigurationResult.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final SdkField<List<OrganizationAdditionalConfigurationResult>> ADDITIONAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalConfiguration").getter(OrganizationFeatureConfigurationResult.getter(OrganizationFeatureConfigurationResult::additionalConfiguration)).setter(OrganizationFeatureConfigurationResult.setter(Builder::additionalConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationAdditionalConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AUTO_ENABLE_FIELD, ADDITIONAL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("autoEnable", AUTO_ENABLE_FIELD);
            this.put("additionalConfiguration", ADDITIONAL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String autoEnable;
    private final List<OrganizationAdditionalConfigurationResult> additionalConfiguration;

    private OrganizationFeatureConfigurationResult(BuilderImpl builder) {
        this.name = builder.name;
        this.autoEnable = builder.autoEnable;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    public final OrgFeature name() {
        return OrgFeature.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final OrgFeatureStatus autoEnable() {
        return OrgFeatureStatus.fromValue(this.autoEnable);
    }

    public final String autoEnableAsString() {
        return this.autoEnable;
    }

    public final boolean hasAdditionalConfiguration() {
        return this.additionalConfiguration != null && !(this.additionalConfiguration instanceof SdkAutoConstructList);
    }

    public final List<OrganizationAdditionalConfigurationResult> additionalConfiguration() {
        return this.additionalConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalConfiguration() ? this.additionalConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureConfigurationResult)) {
            return false;
        }
        OrganizationFeatureConfigurationResult other = (OrganizationFeatureConfigurationResult)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.autoEnableAsString(), other.autoEnableAsString()) && this.hasAdditionalConfiguration() == other.hasAdditionalConfiguration() && Objects.equals(this.additionalConfiguration(), other.additionalConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationFeatureConfigurationResult").add("Name", (Object)this.nameAsString()).add("AutoEnable", (Object)this.autoEnableAsString()).add("AdditionalConfiguration", this.hasAdditionalConfiguration() ? this.additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnableAsString()));
            }
            case "AdditionalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.additionalConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationFeatureConfigurationResult, T> g) {
        return obj -> g.apply((OrganizationFeatureConfigurationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String autoEnable;
        private List<OrganizationAdditionalConfigurationResult> additionalConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationFeatureConfigurationResult model) {
            this.name(model.name);
            this.autoEnable(model.autoEnable);
            this.additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getAutoEnable() {
            return this.autoEnable;
        }

        public final void setAutoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Override
        public final Builder autoEnable(OrgFeatureStatus autoEnable) {
            this.autoEnable(autoEnable == null ? null : autoEnable.toString());
            return this;
        }

        public final List<OrganizationAdditionalConfigurationResult.Builder> getAdditionalConfiguration() {
            List<OrganizationAdditionalConfigurationResult.Builder> result = OrganizationAdditionalConfigurationResultsCopier.copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(Collection<OrganizationAdditionalConfigurationResult.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = OrganizationAdditionalConfigurationResultsCopier.copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(Collection<OrganizationAdditionalConfigurationResult> additionalConfiguration) {
            this.additionalConfiguration = OrganizationAdditionalConfigurationResultsCopier.copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(OrganizationAdditionalConfigurationResult ... additionalConfiguration) {
            this.additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(Consumer<OrganizationAdditionalConfigurationResult.Builder> ... additionalConfiguration) {
            this.additionalConfiguration(Stream.of(additionalConfiguration).map(c -> (OrganizationAdditionalConfigurationResult)((OrganizationAdditionalConfigurationResult.Builder)OrganizationAdditionalConfigurationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrganizationFeatureConfigurationResult build() {
            return new OrganizationFeatureConfigurationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationFeatureConfigurationResult> {
        public Builder name(String var1);

        public Builder name(OrgFeature var1);

        public Builder autoEnable(String var1);

        public Builder autoEnable(OrgFeatureStatus var1);

        public Builder additionalConfiguration(Collection<OrganizationAdditionalConfigurationResult> var1);

        public Builder additionalConfiguration(OrganizationAdditionalConfigurationResult ... var1);

        public Builder additionalConfiguration(Consumer<OrganizationAdditionalConfigurationResult.Builder> ... var1);
    }
}

