/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.Anomaly;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Detection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Detection> {
    private static final SdkField<Anomaly> ANOMALY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Anomaly").getter(Detection.getter(Detection::anomaly)).setter(Detection.setter(Builder::anomaly)).constructor(Anomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomaly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("anomaly", ANOMALY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Anomaly anomaly;

    private Detection(BuilderImpl builder) {
        this.anomaly = builder.anomaly;
    }

    public final Anomaly anomaly() {
        return this.anomaly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anomaly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detection)) {
            return false;
        }
        Detection other = (Detection)obj;
        return Objects.equals(this.anomaly(), other.anomaly());
    }

    public final String toString() {
        return ToString.builder((String)"Detection").add("Anomaly", (Object)this.anomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Anomaly": {
                return Optional.ofNullable(clazz.cast(this.anomaly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Detection, T> g) {
        return obj -> g.apply((Detection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Anomaly anomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(Detection model) {
            this.anomaly(model.anomaly);
        }

        public final Anomaly.Builder getAnomaly() {
            return this.anomaly != null ? this.anomaly.toBuilder() : null;
        }

        public final void setAnomaly(Anomaly.BuilderImpl anomaly) {
            this.anomaly = anomaly != null ? anomaly.build() : null;
        }

        @Override
        public final Builder anomaly(Anomaly anomaly) {
            this.anomaly = anomaly;
            return this;
        }

        public Detection build() {
            return new Detection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Detection> {
        public Builder anomaly(Anomaly var1);

        default public Builder anomaly(Consumer<Anomaly.Builder> anomaly) {
            return this.anomaly((Anomaly)((Anomaly.Builder)Anomaly.builder().applyMutation(anomaly)).build());
        }
    }
}

