/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityContext> {
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Privileged").getter(SecurityContext.getter(SecurityContext::privileged)).setter(SecurityContext.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()}).build();
    private static final SdkField<Boolean> ALLOW_PRIVILEGE_ESCALATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowPrivilegeEscalation").getter(SecurityContext.getter(SecurityContext::allowPrivilegeEscalation)).setter(SecurityContext.setter(Builder::allowPrivilegeEscalation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowPrivilegeEscalation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVILEGED_FIELD, ALLOW_PRIVILEGE_ESCALATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("privileged", PRIVILEGED_FIELD);
            this.put("allowPrivilegeEscalation", ALLOW_PRIVILEGE_ESCALATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean privileged;
    private final Boolean allowPrivilegeEscalation;

    private SecurityContext(BuilderImpl builder) {
        this.privileged = builder.privileged;
        this.allowPrivilegeEscalation = builder.allowPrivilegeEscalation;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public final Boolean allowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowPrivilegeEscalation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext)obj;
        return Objects.equals(this.privileged(), other.privileged()) && Objects.equals(this.allowPrivilegeEscalation(), other.allowPrivilegeEscalation());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityContext").add("Privileged", (Object)this.privileged()).add("AllowPrivilegeEscalation", (Object)this.allowPrivilegeEscalation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
            case "AllowPrivilegeEscalation": {
                return Optional.ofNullable(clazz.cast(this.allowPrivilegeEscalation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityContext, T> g) {
        return obj -> g.apply((SecurityContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean privileged;
        private Boolean allowPrivilegeEscalation;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityContext model) {
            this.privileged(model.privileged);
            this.allowPrivilegeEscalation(model.allowPrivilegeEscalation);
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getAllowPrivilegeEscalation() {
            return this.allowPrivilegeEscalation;
        }

        public final void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        }

        @Override
        public final Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
            return this;
        }

        public SecurityContext build() {
            return new SecurityContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityContext> {
        public Builder privileged(Boolean var1);

        public Builder allowPrivilegeEscalation(Boolean var1);
    }
}

