/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.OrgFeature;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfiguration;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationFeatureStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationFeatureStatistics> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OrganizationFeatureStatistics.getter(OrganizationFeatureStatistics::nameAsString)).setter(OrganizationFeatureStatistics.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> ENABLED_ACCOUNTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EnabledAccountsCount").getter(OrganizationFeatureStatistics.getter(OrganizationFeatureStatistics::enabledAccountsCount)).setter(OrganizationFeatureStatistics.setter(Builder::enabledAccountsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledAccountsCount").build()}).build();
    private static final SdkField<List<OrganizationFeatureStatisticsAdditionalConfiguration>> ADDITIONAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalConfiguration").getter(OrganizationFeatureStatistics.getter(OrganizationFeatureStatistics::additionalConfiguration)).setter(OrganizationFeatureStatistics.setter(Builder::additionalConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationFeatureStatisticsAdditionalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENABLED_ACCOUNTS_COUNT_FIELD, ADDITIONAL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer enabledAccountsCount;
    private final List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration;

    private OrganizationFeatureStatistics(BuilderImpl builder) {
        this.name = builder.name;
        this.enabledAccountsCount = builder.enabledAccountsCount;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    public final OrgFeature name() {
        return OrgFeature.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final Integer enabledAccountsCount() {
        return this.enabledAccountsCount;
    }

    public final boolean hasAdditionalConfiguration() {
        return this.additionalConfiguration != null && !(this.additionalConfiguration instanceof SdkAutoConstructList);
    }

    public final List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration() {
        return this.additionalConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalConfiguration() ? this.additionalConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureStatistics)) {
            return false;
        }
        OrganizationFeatureStatistics other = (OrganizationFeatureStatistics)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.enabledAccountsCount(), other.enabledAccountsCount()) && this.hasAdditionalConfiguration() == other.hasAdditionalConfiguration() && Objects.equals(this.additionalConfiguration(), other.additionalConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationFeatureStatistics").add("Name", (Object)this.nameAsString()).add("EnabledAccountsCount", (Object)this.enabledAccountsCount()).add("AdditionalConfiguration", this.hasAdditionalConfiguration() ? this.additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "EnabledAccountsCount": {
                return Optional.ofNullable(clazz.cast(this.enabledAccountsCount()));
            }
            case "AdditionalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.additionalConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationFeatureStatistics, T> g) {
        return obj -> g.apply((OrganizationFeatureStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer enabledAccountsCount;
        private List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationFeatureStatistics model) {
            this.name(model.name);
            this.enabledAccountsCount(model.enabledAccountsCount);
            this.additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Integer getEnabledAccountsCount() {
            return this.enabledAccountsCount;
        }

        public final void setEnabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
        }

        @Override
        public final Builder enabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
            return this;
        }

        public final List<OrganizationFeatureStatisticsAdditionalConfiguration.Builder> getAdditionalConfiguration() {
            List<OrganizationFeatureStatisticsAdditionalConfiguration.Builder> result = OrganizationFeatureStatisticsAdditionalConfigurationsCopier.copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(Collection<OrganizationFeatureStatisticsAdditionalConfiguration.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = OrganizationFeatureStatisticsAdditionalConfigurationsCopier.copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(Collection<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration) {
            this.additionalConfiguration = OrganizationFeatureStatisticsAdditionalConfigurationsCopier.copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(OrganizationFeatureStatisticsAdditionalConfiguration ... additionalConfiguration) {
            this.additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(Consumer<OrganizationFeatureStatisticsAdditionalConfiguration.Builder> ... additionalConfiguration) {
            this.additionalConfiguration(Stream.of(additionalConfiguration).map(c -> (OrganizationFeatureStatisticsAdditionalConfiguration)((OrganizationFeatureStatisticsAdditionalConfiguration.Builder)OrganizationFeatureStatisticsAdditionalConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrganizationFeatureStatistics build() {
            return new OrganizationFeatureStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationFeatureStatistics> {
        public Builder name(String var1);

        public Builder name(OrgFeature var1);

        public Builder enabledAccountsCount(Integer var1);

        public Builder additionalConfiguration(Collection<OrganizationFeatureStatisticsAdditionalConfiguration> var1);

        public Builder additionalConfiguration(OrganizationFeatureStatisticsAdditionalConfiguration ... var1);

        public Builder additionalConfiguration(Consumer<OrganizationFeatureStatisticsAdditionalConfiguration.Builder> ... var1);
    }
}

