/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ItemPath;
import software.amazon.awssdk.services.guardduty.model.ItemPathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Threat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Threat> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Threat.getter(Threat::name)).setter(Threat.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Threat.getter(Threat::source)).setter(Threat.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<ItemPath>> ITEM_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ItemPaths").getter(Threat.getter(Threat::itemPaths)).setter(Threat.setter(Builder::itemPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD, ITEM_PATHS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String source;
    private final List<ItemPath> itemPaths;

    private Threat(BuilderImpl builder) {
        this.name = builder.name;
        this.source = builder.source;
        this.itemPaths = builder.itemPaths;
    }

    public final String name() {
        return this.name;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasItemPaths() {
        return this.itemPaths != null && !(this.itemPaths instanceof SdkAutoConstructList);
    }

    public final List<ItemPath> itemPaths() {
        return this.itemPaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemPaths() ? this.itemPaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threat)) {
            return false;
        }
        Threat other = (Threat)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && this.hasItemPaths() == other.hasItemPaths() && Objects.equals(this.itemPaths(), other.itemPaths());
    }

    public final String toString() {
        return ToString.builder((String)"Threat").add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("ItemPaths", this.hasItemPaths() ? this.itemPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ItemPaths": {
                return Optional.ofNullable(clazz.cast(this.itemPaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Threat, T> g) {
        return obj -> g.apply((Threat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String source;
        private List<ItemPath> itemPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Threat model) {
            this.name(model.name);
            this.source(model.source);
            this.itemPaths(model.itemPaths);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final List<ItemPath.Builder> getItemPaths() {
            List<ItemPath.Builder> result = ItemPathsCopier.copyToBuilder(this.itemPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemPaths(Collection<ItemPath.BuilderImpl> itemPaths) {
            this.itemPaths = ItemPathsCopier.copyFromBuilder(itemPaths);
        }

        @Override
        public final Builder itemPaths(Collection<ItemPath> itemPaths) {
            this.itemPaths = ItemPathsCopier.copy(itemPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemPaths(ItemPath ... itemPaths) {
            this.itemPaths(Arrays.asList(itemPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemPaths(Consumer<ItemPath.Builder> ... itemPaths) {
            this.itemPaths(Stream.of(itemPaths).map(c -> (ItemPath)((ItemPath.Builder)ItemPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Threat build() {
            return new Threat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Threat> {
        public Builder name(String var1);

        public Builder source(String var1);

        public Builder itemPaths(Collection<ItemPath> var1);

        public Builder itemPaths(ItemPath ... var1);

        public Builder itemPaths(Consumer<ItemPath.Builder> ... var1);
    }
}

