/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalIpDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalIpDetails> {
    private static final SdkField<String> IP_ADDRESS_V4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressV4").getter(LocalIpDetails.getter(LocalIpDetails::ipAddressV4)).setter(LocalIpDetails.setter(Builder::ipAddressV4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressV4").build()}).build();
    private static final SdkField<String> IP_ADDRESS_V6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressV6").getter(LocalIpDetails.getter(LocalIpDetails::ipAddressV6)).setter(LocalIpDetails.setter(Builder::ipAddressV6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressV6").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_V4_FIELD, IP_ADDRESS_V6_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipAddressV4;
    private final String ipAddressV6;

    private LocalIpDetails(BuilderImpl builder) {
        this.ipAddressV4 = builder.ipAddressV4;
        this.ipAddressV6 = builder.ipAddressV6;
    }

    public final String ipAddressV4() {
        return this.ipAddressV4;
    }

    public final String ipAddressV6() {
        return this.ipAddressV6;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressV4());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressV6());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalIpDetails)) {
            return false;
        }
        LocalIpDetails other = (LocalIpDetails)obj;
        return Objects.equals(this.ipAddressV4(), other.ipAddressV4()) && Objects.equals(this.ipAddressV6(), other.ipAddressV6());
    }

    public final String toString() {
        return ToString.builder((String)"LocalIpDetails").add("IpAddressV4", (Object)(this.ipAddressV4() == null ? null : "*** Sensitive Data Redacted ***")).add("IpAddressV6", (Object)(this.ipAddressV6() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddressV4": {
                return Optional.ofNullable(clazz.cast(this.ipAddressV4()));
            }
            case "IpAddressV6": {
                return Optional.ofNullable(clazz.cast(this.ipAddressV6()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalIpDetails, T> g) {
        return obj -> g.apply((LocalIpDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddressV4;
        private String ipAddressV6;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalIpDetails model) {
            this.ipAddressV4(model.ipAddressV4);
            this.ipAddressV6(model.ipAddressV6);
        }

        public final String getIpAddressV4() {
            return this.ipAddressV4;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        @Override
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public final String getIpAddressV6() {
            return this.ipAddressV6;
        }

        public final void setIpAddressV6(String ipAddressV6) {
            this.ipAddressV6 = ipAddressV6;
        }

        @Override
        public final Builder ipAddressV6(String ipAddressV6) {
            this.ipAddressV6 = ipAddressV6;
            return this;
        }

        public LocalIpDetails build() {
            return new LocalIpDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalIpDetails> {
        public Builder ipAddressV4(String var1);

        public Builder ipAddressV6(String var1);
    }
}

