/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.CreateProtectedResource;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanActions;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatus;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatusReason;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatusReasonsListCopier;
import software.amazon.awssdk.services.guardduty.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMalwareProtectionPlanResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetMalwareProtectionPlanResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::arn)).setter(GetMalwareProtectionPlanResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::role)).setter(GetMalwareProtectionPlanResponse.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<CreateProtectedResource> PROTECTED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtectedResource").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::protectedResource)).setter(GetMalwareProtectionPlanResponse.setter(Builder::protectedResource)).constructor(CreateProtectedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedResource").build()}).build();
    private static final SdkField<MalwareProtectionPlanActions> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Actions").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::actions)).setter(GetMalwareProtectionPlanResponse.setter(Builder::actions)).constructor(MalwareProtectionPlanActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::createdAt)).setter(GetMalwareProtectionPlanResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::statusAsString)).setter(GetMalwareProtectionPlanResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<MalwareProtectionPlanStatusReason>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusReasons").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::statusReasons)).setter(GetMalwareProtectionPlanResponse.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MalwareProtectionPlanStatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetMalwareProtectionPlanResponse.getter(GetMalwareProtectionPlanResponse::tags)).setter(GetMalwareProtectionPlanResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ROLE_FIELD, PROTECTED_RESOURCE_FIELD, ACTIONS_FIELD, CREATED_AT_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD, TAGS_FIELD));
    private final String arn;
    private final String role;
    private final CreateProtectedResource protectedResource;
    private final MalwareProtectionPlanActions actions;
    private final Instant createdAt;
    private final String status;
    private final List<MalwareProtectionPlanStatusReason> statusReasons;
    private final Map<String, String> tags;

    private GetMalwareProtectionPlanResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.role = builder.role;
        this.protectedResource = builder.protectedResource;
        this.actions = builder.actions;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String role() {
        return this.role;
    }

    public final CreateProtectedResource protectedResource() {
        return this.protectedResource;
    }

    public final MalwareProtectionPlanActions actions() {
        return this.actions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final MalwareProtectionPlanStatus status() {
        return MalwareProtectionPlanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<MalwareProtectionPlanStatusReason> statusReasons() {
        return this.statusReasons;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMalwareProtectionPlanResponse)) {
            return false;
        }
        GetMalwareProtectionPlanResponse other = (GetMalwareProtectionPlanResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.protectedResource(), other.protectedResource()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetMalwareProtectionPlanResponse").add("Arn", (Object)this.arn()).add("Role", (Object)this.role()).add("ProtectedResource", (Object)this.protectedResource()).add("Actions", (Object)this.actions()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("StatusReasons", this.hasStatusReasons() ? this.statusReasons() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ProtectedResource": {
                return Optional.ofNullable(clazz.cast(this.protectedResource()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMalwareProtectionPlanResponse, T> g) {
        return obj -> g.apply((GetMalwareProtectionPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String role;
        private CreateProtectedResource protectedResource;
        private MalwareProtectionPlanActions actions;
        private Instant createdAt;
        private String status;
        private List<MalwareProtectionPlanStatusReason> statusReasons = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMalwareProtectionPlanResponse model) {
            super(model);
            this.arn(model.arn);
            this.role(model.role);
            this.protectedResource(model.protectedResource);
            this.actions(model.actions);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.statusReasons(model.statusReasons);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final CreateProtectedResource.Builder getProtectedResource() {
            return this.protectedResource != null ? this.protectedResource.toBuilder() : null;
        }

        public final void setProtectedResource(CreateProtectedResource.BuilderImpl protectedResource) {
            this.protectedResource = protectedResource != null ? protectedResource.build() : null;
        }

        @Override
        public final Builder protectedResource(CreateProtectedResource protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        public final MalwareProtectionPlanActions.Builder getActions() {
            return this.actions != null ? this.actions.toBuilder() : null;
        }

        public final void setActions(MalwareProtectionPlanActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MalwareProtectionPlanActions actions) {
            this.actions = actions;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MalwareProtectionPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<MalwareProtectionPlanStatusReason.Builder> getStatusReasons() {
            List<MalwareProtectionPlanStatusReason.Builder> result = MalwareProtectionPlanStatusReasonsListCopier.copyToBuilder(this.statusReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusReasons(Collection<MalwareProtectionPlanStatusReason.BuilderImpl> statusReasons) {
            this.statusReasons = MalwareProtectionPlanStatusReasonsListCopier.copyFromBuilder(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<MalwareProtectionPlanStatusReason> statusReasons) {
            this.statusReasons = MalwareProtectionPlanStatusReasonsListCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(MalwareProtectionPlanStatusReason ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(Consumer<MalwareProtectionPlanStatusReason.Builder> ... statusReasons) {
            this.statusReasons(Stream.of(statusReasons).map(c -> (MalwareProtectionPlanStatusReason)((MalwareProtectionPlanStatusReason.Builder)MalwareProtectionPlanStatusReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetMalwareProtectionPlanResponse build() {
            return new GetMalwareProtectionPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMalwareProtectionPlanResponse> {
        public Builder arn(String var1);

        public Builder role(String var1);

        public Builder protectedResource(CreateProtectedResource var1);

        default public Builder protectedResource(Consumer<CreateProtectedResource.Builder> protectedResource) {
            return this.protectedResource((CreateProtectedResource)((CreateProtectedResource.Builder)CreateProtectedResource.builder().applyMutation(protectedResource)).build());
        }

        public Builder actions(MalwareProtectionPlanActions var1);

        default public Builder actions(Consumer<MalwareProtectionPlanActions.Builder> actions) {
            return this.actions((MalwareProtectionPlanActions)((MalwareProtectionPlanActions.Builder)MalwareProtectionPlanActions.builder().applyMutation(actions)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(MalwareProtectionPlanStatus var1);

        public Builder statusReasons(Collection<MalwareProtectionPlanStatusReason> var1);

        public Builder statusReasons(MalwareProtectionPlanStatusReason ... var1);

        public Builder statusReasons(Consumer<MalwareProtectionPlanStatusReason.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

