/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.Scan;

public class DescribeMalwareScansPublisher
implements SdkPublisher<DescribeMalwareScansResponse> {
    private final GuardDutyAsyncClient client;
    private final DescribeMalwareScansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMalwareScansPublisher(GuardDutyAsyncClient client, DescribeMalwareScansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMalwareScansPublisher(GuardDutyAsyncClient client, DescribeMalwareScansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMalwareScansResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMalwareScansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Scan> scans() {
        Function<DescribeMalwareScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.scans() != null) {
                return response.scans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMalwareScansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMalwareScansResponseFetcher
    implements AsyncPageFetcher<DescribeMalwareScansResponse> {
        private DescribeMalwareScansResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMalwareScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMalwareScansResponse> nextPage(DescribeMalwareScansResponse previousPage) {
            if (previousPage == null) {
                return DescribeMalwareScansPublisher.this.client.describeMalwareScans(DescribeMalwareScansPublisher.this.firstRequest);
            }
            return DescribeMalwareScansPublisher.this.client.describeMalwareScans((DescribeMalwareScansRequest)((Object)DescribeMalwareScansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

