/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.CoverageResourceDetails;
import software.amazon.awssdk.services.guardduty.model.CoverageStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageResource> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(CoverageResource.getter(CoverageResource::resourceId)).setter(CoverageResource.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(CoverageResource.getter(CoverageResource::detectorId)).setter(CoverageResource.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CoverageResource.getter(CoverageResource::accountId)).setter(CoverageResource.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<CoverageResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(CoverageResource.getter(CoverageResource::resourceDetails)).setter(CoverageResource.setter(Builder::resourceDetails)).constructor(CoverageResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDetails").build()}).build();
    private static final SdkField<String> COVERAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoverageStatus").getter(CoverageResource.getter(CoverageResource::coverageStatusAsString)).setter(CoverageResource.setter(Builder::coverageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverageStatus").build()}).build();
    private static final SdkField<String> ISSUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issue").getter(CoverageResource.getter(CoverageResource::issue)).setter(CoverageResource.setter(Builder::issue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issue").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(CoverageResource.getter(CoverageResource::updatedAt)).setter(CoverageResource.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, DETECTOR_ID_FIELD, ACCOUNT_ID_FIELD, RESOURCE_DETAILS_FIELD, COVERAGE_STATUS_FIELD, ISSUE_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String detectorId;
    private final String accountId;
    private final CoverageResourceDetails resourceDetails;
    private final String coverageStatus;
    private final String issue;
    private final Instant updatedAt;

    private CoverageResource(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.detectorId = builder.detectorId;
        this.accountId = builder.accountId;
        this.resourceDetails = builder.resourceDetails;
        this.coverageStatus = builder.coverageStatus;
        this.issue = builder.issue;
        this.updatedAt = builder.updatedAt;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final CoverageResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final CoverageStatus coverageStatus() {
        return CoverageStatus.fromValue(this.coverageStatus);
    }

    public final String coverageStatusAsString() {
        return this.coverageStatus;
    }

    public final String issue() {
        return this.issue;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issue());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageResource)) {
            return false;
        }
        CoverageResource other = (CoverageResource)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.coverageStatusAsString(), other.coverageStatusAsString()) && Objects.equals(this.issue(), other.issue()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageResource").add("ResourceId", (Object)this.resourceId()).add("DetectorId", (Object)this.detectorId()).add("AccountId", (Object)this.accountId()).add("ResourceDetails", (Object)this.resourceDetails()).add("CoverageStatus", (Object)this.coverageStatusAsString()).add("Issue", (Object)this.issue()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "CoverageStatus": {
                return Optional.ofNullable(clazz.cast(this.coverageStatusAsString()));
            }
            case "Issue": {
                return Optional.ofNullable(clazz.cast(this.issue()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageResource, T> g) {
        return obj -> g.apply((CoverageResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String detectorId;
        private String accountId;
        private CoverageResourceDetails resourceDetails;
        private String coverageStatus;
        private String issue;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageResource model) {
            this.resourceId(model.resourceId);
            this.detectorId(model.detectorId);
            this.accountId(model.accountId);
            this.resourceDetails(model.resourceDetails);
            this.coverageStatus(model.coverageStatus);
            this.issue(model.issue);
            this.updatedAt(model.updatedAt);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final CoverageResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(CoverageResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(CoverageResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final String getCoverageStatus() {
            return this.coverageStatus;
        }

        public final void setCoverageStatus(String coverageStatus) {
            this.coverageStatus = coverageStatus;
        }

        @Override
        public final Builder coverageStatus(String coverageStatus) {
            this.coverageStatus = coverageStatus;
            return this;
        }

        @Override
        public final Builder coverageStatus(CoverageStatus coverageStatus) {
            this.coverageStatus(coverageStatus == null ? null : coverageStatus.toString());
            return this;
        }

        public final String getIssue() {
            return this.issue;
        }

        public final void setIssue(String issue) {
            this.issue = issue;
        }

        @Override
        public final Builder issue(String issue) {
            this.issue = issue;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CoverageResource build() {
            return new CoverageResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageResource> {
        public Builder resourceId(String var1);

        public Builder detectorId(String var1);

        public Builder accountId(String var1);

        public Builder resourceDetails(CoverageResourceDetails var1);

        default public Builder resourceDetails(Consumer<CoverageResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((CoverageResourceDetails)((CoverageResourceDetails.Builder)CoverageResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder coverageStatus(String var1);

        public Builder coverageStatus(CoverageStatus var1);

        public Builder issue(String var1);

        public Builder updatedAt(Instant var1);
    }
}

