/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.Scan;

public class DescribeMalwareScansIterable
implements SdkIterable<DescribeMalwareScansResponse> {
    private final GuardDutyClient client;
    private final DescribeMalwareScansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMalwareScansIterable(GuardDutyClient client, DescribeMalwareScansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMalwareScansResponseFetcher();
    }

    public Iterator<DescribeMalwareScansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Scan> scans() {
        Function<DescribeMalwareScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.scans() != null) {
                return response.scans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMalwareScansResponseFetcher
    implements SyncPageFetcher<DescribeMalwareScansResponse> {
        private DescribeMalwareScansResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMalwareScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMalwareScansResponse nextPage(DescribeMalwareScansResponse previousPage) {
            if (previousPage == null) {
                return DescribeMalwareScansIterable.this.client.describeMalwareScans(DescribeMalwareScansIterable.this.firstRequest);
            }
            return DescribeMalwareScansIterable.this.client.describeMalwareScans((DescribeMalwareScansRequest)((Object)DescribeMalwareScansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

