/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AccountIdsCopier;
import software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.MemberFeaturesConfiguration;
import software.amazon.awssdk.services.guardduty.model.MemberFeaturesConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMemberDetectorsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateMemberDetectorsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateMemberDetectorsRequest.getter(UpdateMemberDetectorsRequest::detectorId)).setter(UpdateMemberDetectorsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(UpdateMemberDetectorsRequest.getter(UpdateMemberDetectorsRequest::accountIds)).setter(UpdateMemberDetectorsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceConfigurations> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(UpdateMemberDetectorsRequest.getter(UpdateMemberDetectorsRequest::dataSources)).setter(UpdateMemberDetectorsRequest.setter(Builder::dataSources)).constructor(DataSourceConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final SdkField<List<MemberFeaturesConfiguration>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(UpdateMemberDetectorsRequest.getter(UpdateMemberDetectorsRequest::features)).setter(UpdateMemberDetectorsRequest.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberFeaturesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, ACCOUNT_IDS_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD));
    private final String detectorId;
    private final List<String> accountIds;
    private final DataSourceConfigurations dataSources;
    private final List<MemberFeaturesConfiguration> features;

    private UpdateMemberDetectorsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.accountIds = builder.accountIds;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    @Deprecated
    public final DataSourceConfigurations dataSources() {
        return this.dataSources;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<MemberFeaturesConfiguration> features() {
        return this.features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMemberDetectorsRequest)) {
            return false;
        }
        UpdateMemberDetectorsRequest other = (UpdateMemberDetectorsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.dataSources(), other.dataSources()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMemberDetectorsRequest").add("DetectorId", (Object)this.detectorId()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("DataSources", (Object)this.dataSources()).add("Features", this.hasFeatures() ? this.features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMemberDetectorsRequest, T> g) {
        return obj -> g.apply((UpdateMemberDetectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private DataSourceConfigurations dataSources;
        private List<MemberFeaturesConfiguration> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMemberDetectorsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.accountIds(model.accountIds);
            this.dataSources(model.dataSources);
            this.features(model.features);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Deprecated
        public final DataSourceConfigurations.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(DataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(DataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<MemberFeaturesConfiguration.Builder> getFeatures() {
            List<MemberFeaturesConfiguration.Builder> result = MemberFeaturesConfigurationsCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<MemberFeaturesConfiguration.BuilderImpl> features) {
            this.features = MemberFeaturesConfigurationsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<MemberFeaturesConfiguration> features) {
            this.features = MemberFeaturesConfigurationsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(MemberFeaturesConfiguration ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<MemberFeaturesConfiguration.Builder> ... features) {
            this.features(Stream.of(features).map(c -> (MemberFeaturesConfiguration)((MemberFeaturesConfiguration.Builder)MemberFeaturesConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMemberDetectorsRequest build() {
            return new UpdateMemberDetectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMemberDetectorsRequest> {
        public Builder detectorId(String var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        @Deprecated
        public Builder dataSources(DataSourceConfigurations var1);

        @Deprecated
        default public Builder dataSources(Consumer<DataSourceConfigurations.Builder> dataSources) {
            return this.dataSources((DataSourceConfigurations)((DataSourceConfigurations.Builder)DataSourceConfigurations.builder().applyMutation(dataSources)).build());
        }

        public Builder features(Collection<MemberFeaturesConfiguration> var1);

        public Builder features(MemberFeaturesConfiguration ... var1);

        public Builder features(Consumer<MemberFeaturesConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

