/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.ProcessDetails;
import software.amazon.awssdk.services.guardduty.model.RuntimeContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeDetails> {
    private static final SdkField<ProcessDetails> PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Process").getter(RuntimeDetails.getter(RuntimeDetails::process)).setter(RuntimeDetails.setter(Builder::process)).constructor(ProcessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("process").build()}).build();
    private static final SdkField<RuntimeContext> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Context").getter(RuntimeDetails.getter(RuntimeDetails::context)).setter(RuntimeDetails.setter(Builder::context)).constructor(RuntimeContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESS_FIELD, CONTEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProcessDetails process;
    private final RuntimeContext context;

    private RuntimeDetails(BuilderImpl builder) {
        this.process = builder.process;
        this.context = builder.context;
    }

    public final ProcessDetails process() {
        return this.process;
    }

    public final RuntimeContext context() {
        return this.context;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.process());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeDetails)) {
            return false;
        }
        RuntimeDetails other = (RuntimeDetails)obj;
        return Objects.equals(this.process(), other.process()) && Objects.equals(this.context(), other.context());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimeDetails").add("Process", (Object)this.process()).add("Context", (Object)this.context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Process": {
                return Optional.ofNullable(clazz.cast(this.process()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeDetails, T> g) {
        return obj -> g.apply((RuntimeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProcessDetails process;
        private RuntimeContext context;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeDetails model) {
            this.process(model.process);
            this.context(model.context);
        }

        public final ProcessDetails.Builder getProcess() {
            return this.process != null ? this.process.toBuilder() : null;
        }

        public final void setProcess(ProcessDetails.BuilderImpl process) {
            this.process = process != null ? process.build() : null;
        }

        @Override
        public final Builder process(ProcessDetails process) {
            this.process = process;
            return this;
        }

        public final RuntimeContext.Builder getContext() {
            return this.context != null ? this.context.toBuilder() : null;
        }

        public final void setContext(RuntimeContext.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(RuntimeContext context) {
            this.context = context;
            return this;
        }

        public RuntimeDetails build() {
            return new RuntimeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeDetails> {
        public Builder process(ProcessDetails var1);

        default public Builder process(Consumer<ProcessDetails.Builder> process) {
            return this.process((ProcessDetails)((ProcessDetails.Builder)ProcessDetails.builder().applyMutation(process)).build());
        }

        public Builder context(RuntimeContext var1);

        default public Builder context(Consumer<RuntimeContext.Builder> context) {
            return this.context((RuntimeContext)((RuntimeContext.Builder)RuntimeContext.builder().applyMutation(context)).build());
        }
    }
}

