/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.OrgFeature;
import software.amazon.awssdk.services.guardduty.model.OrgFeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationFeatureConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationFeatureConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OrganizationFeatureConfiguration.getter(OrganizationFeatureConfiguration::nameAsString)).setter(OrganizationFeatureConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEnable").getter(OrganizationFeatureConfiguration.getter(OrganizationFeatureConfiguration::autoEnableAsString)).setter(OrganizationFeatureConfiguration.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AUTO_ENABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String autoEnable;

    private OrganizationFeatureConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.autoEnable = builder.autoEnable;
    }

    public final OrgFeature name() {
        return OrgFeature.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final OrgFeatureStatus autoEnable() {
        return OrgFeatureStatus.fromValue(this.autoEnable);
    }

    public final String autoEnableAsString() {
        return this.autoEnable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureConfiguration)) {
            return false;
        }
        OrganizationFeatureConfiguration other = (OrganizationFeatureConfiguration)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.autoEnableAsString(), other.autoEnableAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationFeatureConfiguration").add("Name", (Object)this.nameAsString()).add("AutoEnable", (Object)this.autoEnableAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnableAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationFeatureConfiguration, T> g) {
        return obj -> g.apply((OrganizationFeatureConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String autoEnable;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationFeatureConfiguration model) {
            this.name(model.name);
            this.autoEnable(model.autoEnable);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getAutoEnable() {
            return this.autoEnable;
        }

        public final void setAutoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Override
        public final Builder autoEnable(OrgFeatureStatus autoEnable) {
            this.autoEnable(autoEnable == null ? null : autoEnable.toString());
            return this;
        }

        public OrganizationFeatureConfiguration build() {
            return new OrganizationFeatureConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationFeatureConfiguration> {
        public Builder name(String var1);

        public Builder name(OrgFeature var1);

        public Builder autoEnable(String var1);

        public Builder autoEnable(OrgFeatureStatus var1);
    }
}

