/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration;
import software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfigurationsCopier;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccount;
import software.amazon.awssdk.services.guardduty.model.UnprocessedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMemberDetectorsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetMemberDetectorsResponse> {
    private static final SdkField<List<MemberDataSourceConfiguration>> MEMBER_DATA_SOURCE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberDataSourceConfigurations").getter(GetMemberDetectorsResponse.getter(GetMemberDetectorsResponse::memberDataSourceConfigurations)).setter(GetMemberDetectorsResponse.setter(Builder::memberDataSourceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberDataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAccounts").getter(GetMemberDetectorsResponse.getter(GetMemberDetectorsResponse::unprocessedAccounts)).setter(GetMemberDetectorsResponse.setter(Builder::unprocessedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DATA_SOURCE_CONFIGURATIONS_FIELD, UNPROCESSED_ACCOUNTS_FIELD));
    private final List<MemberDataSourceConfiguration> memberDataSourceConfigurations;
    private final List<UnprocessedAccount> unprocessedAccounts;

    private GetMemberDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.memberDataSourceConfigurations = builder.memberDataSourceConfigurations;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public final boolean hasMemberDataSourceConfigurations() {
        return this.memberDataSourceConfigurations != null && !(this.memberDataSourceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MemberDataSourceConfiguration> memberDataSourceConfigurations() {
        return this.memberDataSourceConfigurations;
    }

    public final boolean hasUnprocessedAccounts() {
        return this.unprocessedAccounts != null && !(this.unprocessedAccounts instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedAccount> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberDataSourceConfigurations() ? this.memberDataSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMemberDetectorsResponse)) {
            return false;
        }
        GetMemberDetectorsResponse other = (GetMemberDetectorsResponse)((Object)obj);
        return this.hasMemberDataSourceConfigurations() == other.hasMemberDataSourceConfigurations() && Objects.equals(this.memberDataSourceConfigurations(), other.memberDataSourceConfigurations()) && this.hasUnprocessedAccounts() == other.hasUnprocessedAccounts() && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"GetMemberDetectorsResponse").add("MemberDataSourceConfigurations", this.hasMemberDataSourceConfigurations() ? this.memberDataSourceConfigurations() : null).add("UnprocessedAccounts", this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberDataSourceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.memberDataSourceConfigurations()));
            }
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMemberDetectorsResponse, T> g) {
        return obj -> g.apply((GetMemberDetectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<MemberDataSourceConfiguration> memberDataSourceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMemberDetectorsResponse model) {
            super(model);
            this.memberDataSourceConfigurations(model.memberDataSourceConfigurations);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<MemberDataSourceConfiguration.Builder> getMemberDataSourceConfigurations() {
            List<MemberDataSourceConfiguration.Builder> result = MemberDataSourceConfigurationsCopier.copyToBuilder(this.memberDataSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDataSourceConfigurations(Collection<MemberDataSourceConfiguration.BuilderImpl> memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations = MemberDataSourceConfigurationsCopier.copyFromBuilder(memberDataSourceConfigurations);
        }

        @Override
        public final Builder memberDataSourceConfigurations(Collection<MemberDataSourceConfiguration> memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations = MemberDataSourceConfigurationsCopier.copy(memberDataSourceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDataSourceConfigurations(MemberDataSourceConfiguration ... memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations(Arrays.asList(memberDataSourceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDataSourceConfigurations(Consumer<MemberDataSourceConfiguration.Builder> ... memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations(Stream.of(memberDataSourceConfigurations).map(c -> (MemberDataSourceConfiguration)((MemberDataSourceConfiguration.Builder)MemberDataSourceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountsCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (UnprocessedAccount)((UnprocessedAccount.Builder)UnprocessedAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMemberDetectorsResponse build() {
            return new GetMemberDetectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMemberDetectorsResponse> {
        public Builder memberDataSourceConfigurations(Collection<MemberDataSourceConfiguration> var1);

        public Builder memberDataSourceConfigurations(MemberDataSourceConfiguration ... var1);

        public Builder memberDataSourceConfigurations(Consumer<MemberDataSourceConfiguration.Builder> ... var1);

        public Builder unprocessedAccounts(Collection<UnprocessedAccount> var1);

        public Builder unprocessedAccounts(UnprocessedAccount ... var1);

        public Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... var1);
    }
}

