/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CoverageSortKey {
    ACCOUNT_ID("ACCOUNT_ID"),
    CLUSTER_NAME("CLUSTER_NAME"),
    COVERAGE_STATUS("COVERAGE_STATUS"),
    ISSUE("ISSUE"),
    ADDON_VERSION("ADDON_VERSION"),
    UPDATED_AT("UPDATED_AT"),
    EKS_CLUSTER_NAME("EKS_CLUSTER_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CoverageSortKey> VALUE_MAP;
    private final String value;

    private CoverageSortKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CoverageSortKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CoverageSortKey> knownValues() {
        EnumSet<CoverageSortKey> knownValues = EnumSet.allOf(CoverageSortKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CoverageSortKey.class, CoverageSortKey::toString);
    }
}

