/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse;

public class ListPublishingDestinationsPublisher
implements SdkPublisher<ListPublishingDestinationsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListPublishingDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPublishingDestinationsPublisher(GuardDutyAsyncClient client, ListPublishingDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPublishingDestinationsPublisher(GuardDutyAsyncClient client, ListPublishingDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPublishingDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPublishingDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPublishingDestinationsResponseFetcher
    implements AsyncPageFetcher<ListPublishingDestinationsResponse> {
        private ListPublishingDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPublishingDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPublishingDestinationsResponse> nextPage(ListPublishingDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListPublishingDestinationsPublisher.this.client.listPublishingDestinations(ListPublishingDestinationsPublisher.this.firstRequest);
            }
            return ListPublishingDestinationsPublisher.this.client.listPublishingDestinations((ListPublishingDestinationsRequest)((Object)ListPublishingDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

