/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.CoverageEksClusterDetails;
import software.amazon.awssdk.services.guardduty.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageResourceDetails> {
    private static final SdkField<CoverageEksClusterDetails> EKS_CLUSTER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EksClusterDetails").getter(CoverageResourceDetails.getter(CoverageResourceDetails::eksClusterDetails)).setter(CoverageResourceDetails.setter(Builder::eksClusterDetails)).constructor(CoverageEksClusterDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterDetails").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CoverageResourceDetails.getter(CoverageResourceDetails::resourceTypeAsString)).setter(CoverageResourceDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_DETAILS_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CoverageEksClusterDetails eksClusterDetails;
    private final String resourceType;

    private CoverageResourceDetails(BuilderImpl builder) {
        this.eksClusterDetails = builder.eksClusterDetails;
        this.resourceType = builder.resourceType;
    }

    public final CoverageEksClusterDetails eksClusterDetails() {
        return this.eksClusterDetails;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageResourceDetails)) {
            return false;
        }
        CoverageResourceDetails other = (CoverageResourceDetails)obj;
        return Objects.equals(this.eksClusterDetails(), other.eksClusterDetails()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageResourceDetails").add("EksClusterDetails", (Object)this.eksClusterDetails()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EksClusterDetails": {
                return Optional.ofNullable(clazz.cast(this.eksClusterDetails()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageResourceDetails, T> g) {
        return obj -> g.apply((CoverageResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CoverageEksClusterDetails eksClusterDetails;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageResourceDetails model) {
            this.eksClusterDetails(model.eksClusterDetails);
            this.resourceType(model.resourceType);
        }

        public final CoverageEksClusterDetails.Builder getEksClusterDetails() {
            return this.eksClusterDetails != null ? this.eksClusterDetails.toBuilder() : null;
        }

        public final void setEksClusterDetails(CoverageEksClusterDetails.BuilderImpl eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails != null ? eksClusterDetails.build() : null;
        }

        @Override
        public final Builder eksClusterDetails(CoverageEksClusterDetails eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public CoverageResourceDetails build() {
            return new CoverageResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageResourceDetails> {
        public Builder eksClusterDetails(CoverageEksClusterDetails var1);

        default public Builder eksClusterDetails(Consumer<CoverageEksClusterDetails.Builder> eksClusterDetails) {
            return this.eksClusterDetails((CoverageEksClusterDetails)((CoverageEksClusterDetails.Builder)CoverageEksClusterDetails.builder().applyMutation(eksClusterDetails)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);
    }
}

