/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanFilePath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanFilePath> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilePath").getter(ScanFilePath.getter(ScanFilePath::filePath)).setter(ScanFilePath.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeArn").getter(ScanFilePath.getter(ScanFilePath::volumeArn)).setter(ScanFilePath.setter(Builder::volumeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeArn").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(ScanFilePath.getter(ScanFilePath::hash)).setter(ScanFilePath.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(ScanFilePath.getter(ScanFilePath::fileName)).setter(ScanFilePath.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, VOLUME_ARN_FIELD, HASH_FIELD, FILE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String volumeArn;
    private final String hash;
    private final String fileName;

    private ScanFilePath(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.volumeArn = builder.volumeArn;
        this.hash = builder.hash;
        this.fileName = builder.fileName;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String volumeArn() {
        return this.volumeArn;
    }

    public final String hash() {
        return this.hash;
    }

    public final String fileName() {
        return this.fileName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanFilePath)) {
            return false;
        }
        ScanFilePath other = (ScanFilePath)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.volumeArn(), other.volumeArn()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.fileName(), other.fileName());
    }

    public final String toString() {
        return ToString.builder((String)"ScanFilePath").add("FilePath", (Object)this.filePath()).add("VolumeArn", (Object)this.volumeArn()).add("Hash", (Object)this.hash()).add("FileName", (Object)this.fileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "VolumeArn": {
                return Optional.ofNullable(clazz.cast(this.volumeArn()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanFilePath, T> g) {
        return obj -> g.apply((ScanFilePath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private String volumeArn;
        private String hash;
        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanFilePath model) {
            this.filePath(model.filePath);
            this.volumeArn(model.volumeArn);
            this.hash(model.hash);
            this.fileName(model.fileName);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getVolumeArn() {
            return this.volumeArn;
        }

        public final void setVolumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
        }

        @Override
        public final Builder volumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ScanFilePath build() {
            return new ScanFilePath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanFilePath> {
        public Builder filePath(String var1);

        public Builder volumeArn(String var1);

        public Builder hash(String var1);

        public Builder fileName(String var1);
    }
}

