/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AccountLevelPermissions;
import software.amazon.awssdk.services.guardduty.model.BucketLevelPermissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionConfiguration> {
    private static final SdkField<BucketLevelPermissions> BUCKET_LEVEL_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketLevelPermissions").getter(PermissionConfiguration.getter(PermissionConfiguration::bucketLevelPermissions)).setter(PermissionConfiguration.setter(Builder::bucketLevelPermissions)).constructor(BucketLevelPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketLevelPermissions").build()}).build();
    private static final SdkField<AccountLevelPermissions> ACCOUNT_LEVEL_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountLevelPermissions").getter(PermissionConfiguration.getter(PermissionConfiguration::accountLevelPermissions)).setter(PermissionConfiguration.setter(Builder::accountLevelPermissions)).constructor(AccountLevelPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountLevelPermissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_LEVEL_PERMISSIONS_FIELD, ACCOUNT_LEVEL_PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final BucketLevelPermissions bucketLevelPermissions;
    private final AccountLevelPermissions accountLevelPermissions;

    private PermissionConfiguration(BuilderImpl builder) {
        this.bucketLevelPermissions = builder.bucketLevelPermissions;
        this.accountLevelPermissions = builder.accountLevelPermissions;
    }

    public final BucketLevelPermissions bucketLevelPermissions() {
        return this.bucketLevelPermissions;
    }

    public final AccountLevelPermissions accountLevelPermissions() {
        return this.accountLevelPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLevelPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLevelPermissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionConfiguration)) {
            return false;
        }
        PermissionConfiguration other = (PermissionConfiguration)obj;
        return Objects.equals(this.bucketLevelPermissions(), other.bucketLevelPermissions()) && Objects.equals(this.accountLevelPermissions(), other.accountLevelPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionConfiguration").add("BucketLevelPermissions", (Object)this.bucketLevelPermissions()).add("AccountLevelPermissions", (Object)this.accountLevelPermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketLevelPermissions": {
                return Optional.ofNullable(clazz.cast(this.bucketLevelPermissions()));
            }
            case "AccountLevelPermissions": {
                return Optional.ofNullable(clazz.cast(this.accountLevelPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionConfiguration, T> g) {
        return obj -> g.apply((PermissionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BucketLevelPermissions bucketLevelPermissions;
        private AccountLevelPermissions accountLevelPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionConfiguration model) {
            this.bucketLevelPermissions(model.bucketLevelPermissions);
            this.accountLevelPermissions(model.accountLevelPermissions);
        }

        public final BucketLevelPermissions.Builder getBucketLevelPermissions() {
            return this.bucketLevelPermissions != null ? this.bucketLevelPermissions.toBuilder() : null;
        }

        public final void setBucketLevelPermissions(BucketLevelPermissions.BuilderImpl bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions != null ? bucketLevelPermissions.build() : null;
        }

        @Override
        public final Builder bucketLevelPermissions(BucketLevelPermissions bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions;
            return this;
        }

        public final AccountLevelPermissions.Builder getAccountLevelPermissions() {
            return this.accountLevelPermissions != null ? this.accountLevelPermissions.toBuilder() : null;
        }

        public final void setAccountLevelPermissions(AccountLevelPermissions.BuilderImpl accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions != null ? accountLevelPermissions.build() : null;
        }

        @Override
        public final Builder accountLevelPermissions(AccountLevelPermissions accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions;
            return this;
        }

        public PermissionConfiguration build() {
            return new PermissionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionConfiguration> {
        public Builder bucketLevelPermissions(BucketLevelPermissions var1);

        default public Builder bucketLevelPermissions(Consumer<BucketLevelPermissions.Builder> bucketLevelPermissions) {
            return this.bucketLevelPermissions((BucketLevelPermissions)((BucketLevelPermissions.Builder)BucketLevelPermissions.builder().applyMutation(bucketLevelPermissions)).build());
        }

        public Builder accountLevelPermissions(AccountLevelPermissions var1);

        default public Builder accountLevelPermissions(Consumer<AccountLevelPermissions.Builder> accountLevelPermissions) {
            return this.accountLevelPermissions((AccountLevelPermissions)((AccountLevelPermissions.Builder)AccountLevelPermissions.builder().applyMutation(accountLevelPermissions)).build());
        }
    }
}

