/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse;

public class GetUsageStatisticsPublisher
implements SdkPublisher<GetUsageStatisticsResponse> {
    private final GuardDutyAsyncClient client;
    private final GetUsageStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUsageStatisticsPublisher(GuardDutyAsyncClient client, GetUsageStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUsageStatisticsPublisher(GuardDutyAsyncClient client, GetUsageStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUsageStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUsageStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetUsageStatisticsResponseFetcher
    implements AsyncPageFetcher<GetUsageStatisticsResponse> {
        private GetUsageStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(GetUsageStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetUsageStatisticsResponse> nextPage(GetUsageStatisticsResponse previousPage) {
            if (previousPage == null) {
                return GetUsageStatisticsPublisher.this.client.getUsageStatistics(GetUsageStatisticsPublisher.this.firstRequest);
            }
            return GetUsageStatisticsPublisher.this.client.getUsageStatistics((GetUsageStatisticsRequest)((Object)GetUsageStatisticsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

