/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMalwareScanSettingsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetMalwareScanSettingsResponse> {
    private static final SdkField<ScanResourceCriteria> SCAN_RESOURCE_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanResourceCriteria").getter(GetMalwareScanSettingsResponse.getter(GetMalwareScanSettingsResponse::scanResourceCriteria)).setter(GetMalwareScanSettingsResponse.setter(Builder::scanResourceCriteria)).constructor(ScanResourceCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResourceCriteria").build()}).build();
    private static final SdkField<String> EBS_SNAPSHOT_PRESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EbsSnapshotPreservation").getter(GetMalwareScanSettingsResponse.getter(GetMalwareScanSettingsResponse::ebsSnapshotPreservationAsString)).setter(GetMalwareScanSettingsResponse.setter(Builder::ebsSnapshotPreservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshotPreservation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_RESOURCE_CRITERIA_FIELD, EBS_SNAPSHOT_PRESERVATION_FIELD));
    private final ScanResourceCriteria scanResourceCriteria;
    private final String ebsSnapshotPreservation;

    private GetMalwareScanSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.scanResourceCriteria = builder.scanResourceCriteria;
        this.ebsSnapshotPreservation = builder.ebsSnapshotPreservation;
    }

    public final ScanResourceCriteria scanResourceCriteria() {
        return this.scanResourceCriteria;
    }

    public final EbsSnapshotPreservation ebsSnapshotPreservation() {
        return EbsSnapshotPreservation.fromValue(this.ebsSnapshotPreservation);
    }

    public final String ebsSnapshotPreservationAsString() {
        return this.ebsSnapshotPreservation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResourceCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsSnapshotPreservationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMalwareScanSettingsResponse)) {
            return false;
        }
        GetMalwareScanSettingsResponse other = (GetMalwareScanSettingsResponse)((Object)obj);
        return Objects.equals(this.scanResourceCriteria(), other.scanResourceCriteria()) && Objects.equals(this.ebsSnapshotPreservationAsString(), other.ebsSnapshotPreservationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetMalwareScanSettingsResponse").add("ScanResourceCriteria", (Object)this.scanResourceCriteria()).add("EbsSnapshotPreservation", (Object)this.ebsSnapshotPreservationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScanResourceCriteria": {
                return Optional.ofNullable(clazz.cast(this.scanResourceCriteria()));
            }
            case "EbsSnapshotPreservation": {
                return Optional.ofNullable(clazz.cast(this.ebsSnapshotPreservationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMalwareScanSettingsResponse, T> g) {
        return obj -> g.apply((GetMalwareScanSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private ScanResourceCriteria scanResourceCriteria;
        private String ebsSnapshotPreservation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMalwareScanSettingsResponse model) {
            super(model);
            this.scanResourceCriteria(model.scanResourceCriteria);
            this.ebsSnapshotPreservation(model.ebsSnapshotPreservation);
        }

        public final ScanResourceCriteria.Builder getScanResourceCriteria() {
            return this.scanResourceCriteria != null ? this.scanResourceCriteria.toBuilder() : null;
        }

        public final void setScanResourceCriteria(ScanResourceCriteria.BuilderImpl scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria != null ? scanResourceCriteria.build() : null;
        }

        @Override
        public final Builder scanResourceCriteria(ScanResourceCriteria scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria;
            return this;
        }

        public final String getEbsSnapshotPreservation() {
            return this.ebsSnapshotPreservation;
        }

        public final void setEbsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
        }

        @Override
        public final Builder ebsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
            return this;
        }

        @Override
        public final Builder ebsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation(ebsSnapshotPreservation == null ? null : ebsSnapshotPreservation.toString());
            return this;
        }

        @Override
        public GetMalwareScanSettingsResponse build() {
            return new GetMalwareScanSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMalwareScanSettingsResponse> {
        public Builder scanResourceCriteria(ScanResourceCriteria var1);

        default public Builder scanResourceCriteria(Consumer<ScanResourceCriteria.Builder> scanResourceCriteria) {
            return this.scanResourceCriteria((ScanResourceCriteria)((ScanResourceCriteria.Builder)ScanResourceCriteria.builder().applyMutation(scanResourceCriteria)).build());
        }

        public Builder ebsSnapshotPreservation(String var1);

        public Builder ebsSnapshotPreservation(EbsSnapshotPreservation var1);
    }
}

