/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.OrderBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SortCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SortCriteria> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(SortCriteria.getter(SortCriteria::attributeName)).setter(SortCriteria.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()}).build();
    private static final SdkField<String> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderBy").getter(SortCriteria.getter(SortCriteria::orderByAsString)).setter(SortCriteria.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, ORDER_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final String orderBy;

    private SortCriteria(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.orderBy = builder.orderBy;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final OrderBy orderBy() {
        return OrderBy.fromValue(this.orderBy);
    }

    public final String orderByAsString() {
        return this.orderBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortCriteria)) {
            return false;
        }
        SortCriteria other = (SortCriteria)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.orderByAsString(), other.orderByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SortCriteria").add("AttributeName", (Object)this.attributeName()).add("OrderBy", (Object)this.orderByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "OrderBy": {
                return Optional.ofNullable(clazz.cast(this.orderByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SortCriteria, T> g) {
        return obj -> g.apply((SortCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SortCriteria model) {
            this.attributeName(model.attributeName);
            this.orderBy(model.orderBy);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        @Transient
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        @Transient
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        @Transient
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public SortCriteria build() {
            return new SortCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SortCriteria> {
        public Builder attributeName(String var1);

        public Builder orderBy(String var1);

        public Builder orderBy(OrderBy var1);
    }
}

