/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigurationResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnable").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::autoEnable)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final SdkField<Boolean> MEMBER_ACCOUNT_LIMIT_REACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MemberAccountLimitReached").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::memberAccountLimitReached)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::memberAccountLimitReached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountLimitReached").build()}).build();
    private static final SdkField<OrganizationDataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::dataSources)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::dataSources)).constructor(OrganizationDataSourceConfigurationsResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD, MEMBER_ACCOUNT_LIMIT_REACHED_FIELD, DATA_SOURCES_FIELD));
    private final Boolean autoEnable;
    private final Boolean memberAccountLimitReached;
    private final OrganizationDataSourceConfigurationsResult dataSources;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.memberAccountLimitReached = builder.memberAccountLimitReached;
        this.dataSources = builder.dataSources;
    }

    public final Boolean autoEnable() {
        return this.autoEnable;
    }

    public final Boolean memberAccountLimitReached() {
        return this.memberAccountLimitReached;
    }

    public final OrganizationDataSourceConfigurationsResult dataSources() {
        return this.dataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse)((Object)obj);
        return Objects.equals(this.autoEnable(), other.autoEnable()) && Objects.equals(this.memberAccountLimitReached(), other.memberAccountLimitReached()) && Objects.equals(this.dataSources(), other.dataSources());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigurationResponse").add("AutoEnable", (Object)this.autoEnable()).add("MemberAccountLimitReached", (Object)this.memberAccountLimitReached()).add("DataSources", (Object)this.dataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnable()));
            }
            case "MemberAccountLimitReached": {
                return Optional.ofNullable(clazz.cast(this.memberAccountLimitReached()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private Boolean autoEnable;
        private Boolean memberAccountLimitReached;
        private OrganizationDataSourceConfigurationsResult dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            this.autoEnable(model.autoEnable);
            this.memberAccountLimitReached(model.memberAccountLimitReached);
            this.dataSources(model.dataSources);
        }

        public final Boolean getAutoEnable() {
            return this.autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final Boolean getMemberAccountLimitReached() {
            return this.memberAccountLimitReached;
        }

        public final void setMemberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
        }

        @Override
        public final Builder memberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
            return this;
        }

        public final OrganizationDataSourceConfigurationsResult.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        public final void setDataSources(OrganizationDataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(OrganizationDataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        public Builder autoEnable(Boolean var1);

        public Builder memberAccountLimitReached(Boolean var1);

        public Builder dataSources(OrganizationDataSourceConfigurationsResult var1);

        default public Builder dataSources(Consumer<OrganizationDataSourceConfigurationsResult.Builder> dataSources) {
            return this.dataSources((OrganizationDataSourceConfigurationsResult)((OrganizationDataSourceConfigurationsResult.Builder)OrganizationDataSourceConfigurationsResult.builder().applyMutation(dataSources)).build());
        }
    }
}

