/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSource {
    FLOW_LOGS("FLOW_LOGS"),
    CLOUD_TRAIL("CLOUD_TRAIL"),
    DNS_LOGS("DNS_LOGS"),
    S3_LOGS("S3_LOGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSource> knownValues() {
        return Stream.of(DataSource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

