/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockPublicAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockPublicAccess> {
    private static final SdkField<Boolean> IGNORE_PUBLIC_ACLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnorePublicAcls").getter(BlockPublicAccess.getter(BlockPublicAccess::ignorePublicAcls)).setter(BlockPublicAccess.setter(Builder::ignorePublicAcls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignorePublicAcls").build()}).build();
    private static final SdkField<Boolean> RESTRICT_PUBLIC_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RestrictPublicBuckets").getter(BlockPublicAccess.getter(BlockPublicAccess::restrictPublicBuckets)).setter(BlockPublicAccess.setter(Builder::restrictPublicBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictPublicBuckets").build()}).build();
    private static final SdkField<Boolean> BLOCK_PUBLIC_ACLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BlockPublicAcls").getter(BlockPublicAccess.getter(BlockPublicAccess::blockPublicAcls)).setter(BlockPublicAccess.setter(Builder::blockPublicAcls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAcls").build()}).build();
    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BlockPublicPolicy").getter(BlockPublicAccess.getter(BlockPublicAccess::blockPublicPolicy)).setter(BlockPublicAccess.setter(Builder::blockPublicPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGNORE_PUBLIC_ACLS_FIELD, RESTRICT_PUBLIC_BUCKETS_FIELD, BLOCK_PUBLIC_ACLS_FIELD, BLOCK_PUBLIC_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean ignorePublicAcls;
    private final Boolean restrictPublicBuckets;
    private final Boolean blockPublicAcls;
    private final Boolean blockPublicPolicy;

    private BlockPublicAccess(BuilderImpl builder) {
        this.ignorePublicAcls = builder.ignorePublicAcls;
        this.restrictPublicBuckets = builder.restrictPublicBuckets;
        this.blockPublicAcls = builder.blockPublicAcls;
        this.blockPublicPolicy = builder.blockPublicPolicy;
    }

    public final Boolean ignorePublicAcls() {
        return this.ignorePublicAcls;
    }

    public final Boolean restrictPublicBuckets() {
        return this.restrictPublicBuckets;
    }

    public final Boolean blockPublicAcls() {
        return this.blockPublicAcls;
    }

    public final Boolean blockPublicPolicy() {
        return this.blockPublicPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ignorePublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictPublicBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPublicAccess)) {
            return false;
        }
        BlockPublicAccess other = (BlockPublicAccess)obj;
        return Objects.equals(this.ignorePublicAcls(), other.ignorePublicAcls()) && Objects.equals(this.restrictPublicBuckets(), other.restrictPublicBuckets()) && Objects.equals(this.blockPublicAcls(), other.blockPublicAcls()) && Objects.equals(this.blockPublicPolicy(), other.blockPublicPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"BlockPublicAccess").add("IgnorePublicAcls", (Object)this.ignorePublicAcls()).add("RestrictPublicBuckets", (Object)this.restrictPublicBuckets()).add("BlockPublicAcls", (Object)this.blockPublicAcls()).add("BlockPublicPolicy", (Object)this.blockPublicPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IgnorePublicAcls": {
                return Optional.ofNullable(clazz.cast(this.ignorePublicAcls()));
            }
            case "RestrictPublicBuckets": {
                return Optional.ofNullable(clazz.cast(this.restrictPublicBuckets()));
            }
            case "BlockPublicAcls": {
                return Optional.ofNullable(clazz.cast(this.blockPublicAcls()));
            }
            case "BlockPublicPolicy": {
                return Optional.ofNullable(clazz.cast(this.blockPublicPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockPublicAccess, T> g) {
        return obj -> g.apply((BlockPublicAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean ignorePublicAcls;
        private Boolean restrictPublicBuckets;
        private Boolean blockPublicAcls;
        private Boolean blockPublicPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockPublicAccess model) {
            this.ignorePublicAcls(model.ignorePublicAcls);
            this.restrictPublicBuckets(model.restrictPublicBuckets);
            this.blockPublicAcls(model.blockPublicAcls);
            this.blockPublicPolicy(model.blockPublicPolicy);
        }

        public final Boolean getIgnorePublicAcls() {
            return this.ignorePublicAcls;
        }

        @Override
        public final Builder ignorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        public final void setIgnorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
        }

        public final Boolean getRestrictPublicBuckets() {
            return this.restrictPublicBuckets;
        }

        @Override
        public final Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        public final void setRestrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
        }

        public final Boolean getBlockPublicAcls() {
            return this.blockPublicAcls;
        }

        @Override
        public final Builder blockPublicAcls(Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
            return this;
        }

        public final void setBlockPublicAcls(Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
        }

        public final Boolean getBlockPublicPolicy() {
            return this.blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        public BlockPublicAccess build() {
            return new BlockPublicAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockPublicAccess> {
        public Builder ignorePublicAcls(Boolean var1);

        public Builder restrictPublicBuckets(Boolean var1);

        public Builder blockPublicAcls(Boolean var1);

        public Builder blockPublicPolicy(Boolean var1);
    }
}

