/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AccessKeyDetails;
import software.amazon.awssdk.services.guardduty.model.InstanceDetails;
import software.amazon.awssdk.services.guardduty.model.S3BucketDetail;
import software.amazon.awssdk.services.guardduty.model.S3BucketDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<AccessKeyDetails> ACCESS_KEY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessKeyDetails").getter(Resource.getter(Resource::accessKeyDetails)).setter(Resource.setter(Builder::accessKeyDetails)).constructor(AccessKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyDetails").build()}).build();
    private static final SdkField<List<S3BucketDetail>> S3_BUCKET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3BucketDetails").getter(Resource.getter(Resource::s3BucketDetails)).setter(Resource.setter(Builder::s3BucketDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3BucketDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceDetails").getter(Resource.getter(Resource::instanceDetails)).setter(Resource.setter(Builder::instanceDetails)).constructor(InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDetails").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(Resource.getter(Resource::resourceType)).setter(Resource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_DETAILS_FIELD, S3_BUCKET_DETAILS_FIELD, INSTANCE_DETAILS_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccessKeyDetails accessKeyDetails;
    private final List<S3BucketDetail> s3BucketDetails;
    private final InstanceDetails instanceDetails;
    private final String resourceType;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.s3BucketDetails = builder.s3BucketDetails;
        this.instanceDetails = builder.instanceDetails;
        this.resourceType = builder.resourceType;
    }

    public final AccessKeyDetails accessKeyDetails() {
        return this.accessKeyDetails;
    }

    public final boolean hasS3BucketDetails() {
        return this.s3BucketDetails != null && !(this.s3BucketDetails instanceof SdkAutoConstructList);
    }

    public final List<S3BucketDetail> s3BucketDetails() {
        return this.s3BucketDetails;
    }

    public final InstanceDetails instanceDetails() {
        return this.instanceDetails;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3BucketDetails() ? this.s3BucketDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.accessKeyDetails(), other.accessKeyDetails()) && this.hasS3BucketDetails() == other.hasS3BucketDetails() && Objects.equals(this.s3BucketDetails(), other.s3BucketDetails()) && Objects.equals(this.instanceDetails(), other.instanceDetails()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("AccessKeyDetails", (Object)this.accessKeyDetails()).add("S3BucketDetails", this.hasS3BucketDetails() ? this.s3BucketDetails() : null).add("InstanceDetails", (Object)this.instanceDetails()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.accessKeyDetails()));
            }
            case "S3BucketDetails": {
                return Optional.ofNullable(clazz.cast(this.s3BucketDetails()));
            }
            case "InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.instanceDetails()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessKeyDetails accessKeyDetails;
        private List<S3BucketDetail> s3BucketDetails = DefaultSdkAutoConstructList.getInstance();
        private InstanceDetails instanceDetails;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.accessKeyDetails(model.accessKeyDetails);
            this.s3BucketDetails(model.s3BucketDetails);
            this.instanceDetails(model.instanceDetails);
            this.resourceType(model.resourceType);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return this.accessKeyDetails != null ? this.accessKeyDetails.toBuilder() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        public final List<S3BucketDetail.Builder> getS3BucketDetails() {
            List<S3BucketDetail.Builder> result = S3BucketDetailsCopier.copyToBuilder(this.s3BucketDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder s3BucketDetails(Collection<S3BucketDetail> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copy(s3BucketDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(S3BucketDetail ... s3BucketDetails) {
            this.s3BucketDetails(Arrays.asList(s3BucketDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(Consumer<S3BucketDetail.Builder> ... s3BucketDetails) {
            this.s3BucketDetails(Stream.of(s3BucketDetails).map(c -> (S3BucketDetail)((S3BucketDetail.Builder)S3BucketDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3BucketDetails(Collection<S3BucketDetail.BuilderImpl> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copyFromBuilder(s3BucketDetails);
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return this.instanceDetails != null ? this.instanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder accessKeyDetails(AccessKeyDetails var1);

        default public Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return this.accessKeyDetails((AccessKeyDetails)((AccessKeyDetails.Builder)AccessKeyDetails.builder().applyMutation(accessKeyDetails)).build());
        }

        public Builder s3BucketDetails(Collection<S3BucketDetail> var1);

        public Builder s3BucketDetails(S3BucketDetail ... var1);

        public Builder s3BucketDetails(Consumer<S3BucketDetail.Builder> ... var1);

        public Builder instanceDetails(InstanceDetails var1);

        default public Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return this.instanceDetails((InstanceDetails)((InstanceDetails.Builder)InstanceDetails.builder().applyMutation(instanceDetails)).build());
        }

        public Builder resourceType(String var1);
    }
}

