/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of GuardDuty usage. If a UsageStatisticType is provided the result for other types will be null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageStatistics implements SdkPojo, Serializable, ToCopyableBuilder<UsageStatistics.Builder, UsageStatistics> {
    private static final SdkField<List<UsageAccountResult>> SUM_BY_ACCOUNT_FIELD = SdkField
            .<List<UsageAccountResult>> builder(MarshallingType.LIST)
            .memberName("SumByAccount")
            .getter(getter(UsageStatistics::sumByAccount))
            .setter(setter(Builder::sumByAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByAccount").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageAccountResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageAccountResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageDataSourceResult>> SUM_BY_DATA_SOURCE_FIELD = SdkField
            .<List<UsageDataSourceResult>> builder(MarshallingType.LIST)
            .memberName("SumByDataSource")
            .getter(getter(UsageStatistics::sumByDataSource))
            .setter(setter(Builder::sumByDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByDataSource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageDataSourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageDataSourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageResourceResult>> SUM_BY_RESOURCE_FIELD = SdkField
            .<List<UsageResourceResult>> builder(MarshallingType.LIST)
            .memberName("SumByResource")
            .getter(getter(UsageStatistics::sumByResource))
            .setter(setter(Builder::sumByResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByResource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageResourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageResourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageResourceResult>> TOP_RESOURCES_FIELD = SdkField
            .<List<UsageResourceResult>> builder(MarshallingType.LIST)
            .memberName("TopResources")
            .getter(getter(UsageStatistics::topResources))
            .setter(setter(Builder::topResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageResourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageResourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUM_BY_ACCOUNT_FIELD,
            SUM_BY_DATA_SOURCE_FIELD, SUM_BY_RESOURCE_FIELD, TOP_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<UsageAccountResult> sumByAccount;

    private final List<UsageDataSourceResult> sumByDataSource;

    private final List<UsageResourceResult> sumByResource;

    private final List<UsageResourceResult> topResources;

    private UsageStatistics(BuilderImpl builder) {
        this.sumByAccount = builder.sumByAccount;
        this.sumByDataSource = builder.sumByDataSource;
        this.sumByResource = builder.sumByResource;
        this.topResources = builder.topResources;
    }

    /**
     * Returns true if the SumByAccount property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSumByAccount() {
        return sumByAccount != null && !(sumByAccount instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by account ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSumByAccount()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The usage statistic sum organized by account ID.
     */
    public final List<UsageAccountResult> sumByAccount() {
        return sumByAccount;
    }

    /**
     * Returns true if the SumByDataSource property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSumByDataSource() {
        return sumByDataSource != null && !(sumByDataSource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by on data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSumByDataSource()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The usage statistic sum organized by on data source.
     */
    public final List<UsageDataSourceResult> sumByDataSource() {
        return sumByDataSource;
    }

    /**
     * Returns true if the SumByResource property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSumByResource() {
        return sumByResource != null && !(sumByResource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSumByResource()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The usage statistic sum organized by resource.
     */
    public final List<UsageResourceResult> sumByResource() {
        return sumByResource;
    }

    /**
     * Returns true if the TopResources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTopResources() {
        return topResources != null && !(topResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least expensive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTopResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
     *         expensive.
     */
    public final List<UsageResourceResult> topResources() {
        return topResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByAccount() ? sumByAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByDataSource() ? sumByDataSource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByResource() ? sumByResource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopResources() ? topResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageStatistics)) {
            return false;
        }
        UsageStatistics other = (UsageStatistics) obj;
        return hasSumByAccount() == other.hasSumByAccount() && Objects.equals(sumByAccount(), other.sumByAccount())
                && hasSumByDataSource() == other.hasSumByDataSource()
                && Objects.equals(sumByDataSource(), other.sumByDataSource()) && hasSumByResource() == other.hasSumByResource()
                && Objects.equals(sumByResource(), other.sumByResource()) && hasTopResources() == other.hasTopResources()
                && Objects.equals(topResources(), other.topResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageStatistics").add("SumByAccount", hasSumByAccount() ? sumByAccount() : null)
                .add("SumByDataSource", hasSumByDataSource() ? sumByDataSource() : null)
                .add("SumByResource", hasSumByResource() ? sumByResource() : null)
                .add("TopResources", hasTopResources() ? topResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SumByAccount":
            return Optional.ofNullable(clazz.cast(sumByAccount()));
        case "SumByDataSource":
            return Optional.ofNullable(clazz.cast(sumByDataSource()));
        case "SumByResource":
            return Optional.ofNullable(clazz.cast(sumByResource()));
        case "TopResources":
            return Optional.ofNullable(clazz.cast(topResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageStatistics, T> g) {
        return obj -> g.apply((UsageStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageStatistics> {
        /**
         * <p>
         * The usage statistic sum organized by account ID.
         * </p>
         * 
         * @param sumByAccount
         *        The usage statistic sum organized by account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByAccount(Collection<UsageAccountResult> sumByAccount);

        /**
         * <p>
         * The usage statistic sum organized by account ID.
         * </p>
         * 
         * @param sumByAccount
         *        The usage statistic sum organized by account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByAccount(UsageAccountResult... sumByAccount);

        /**
         * <p>
         * The usage statistic sum organized by account ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageAccountResult>.Builder} avoiding the
         * need to create one manually via {@link List<UsageAccountResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageAccountResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #sumByAccount(List<UsageAccountResult>)}.
         * 
         * @param sumByAccount
         *        a consumer that will call methods on {@link List<UsageAccountResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByAccount(List<UsageAccountResult>)
         */
        Builder sumByAccount(Consumer<UsageAccountResult.Builder>... sumByAccount);

        /**
         * <p>
         * The usage statistic sum organized by on data source.
         * </p>
         * 
         * @param sumByDataSource
         *        The usage statistic sum organized by on data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByDataSource(Collection<UsageDataSourceResult> sumByDataSource);

        /**
         * <p>
         * The usage statistic sum organized by on data source.
         * </p>
         * 
         * @param sumByDataSource
         *        The usage statistic sum organized by on data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByDataSource(UsageDataSourceResult... sumByDataSource);

        /**
         * <p>
         * The usage statistic sum organized by on data source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageDataSourceResult>.Builder} avoiding
         * the need to create one manually via {@link List<UsageDataSourceResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageDataSourceResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #sumByDataSource(List<UsageDataSourceResult>)}.
         * 
         * @param sumByDataSource
         *        a consumer that will call methods on {@link List<UsageDataSourceResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByDataSource(List<UsageDataSourceResult>)
         */
        Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder>... sumByDataSource);

        /**
         * <p>
         * The usage statistic sum organized by resource.
         * </p>
         * 
         * @param sumByResource
         *        The usage statistic sum organized by resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByResource(Collection<UsageResourceResult> sumByResource);

        /**
         * <p>
         * The usage statistic sum organized by resource.
         * </p>
         * 
         * @param sumByResource
         *        The usage statistic sum organized by resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByResource(UsageResourceResult... sumByResource);

        /**
         * <p>
         * The usage statistic sum organized by resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageResourceResult>.Builder} avoiding the
         * need to create one manually via {@link List<UsageResourceResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageResourceResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #sumByResource(List<UsageResourceResult>)}.
         * 
         * @param sumByResource
         *        a consumer that will call methods on {@link List<UsageResourceResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByResource(List<UsageResourceResult>)
         */
        Builder sumByResource(Consumer<UsageResourceResult.Builder>... sumByResource);

        /**
         * <p>
         * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         * expensive.
         * </p>
         * 
         * @param topResources
         *        Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         *        expensive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topResources(Collection<UsageResourceResult> topResources);

        /**
         * <p>
         * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         * expensive.
         * </p>
         * 
         * @param topResources
         *        Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         *        expensive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topResources(UsageResourceResult... topResources);

        /**
         * <p>
         * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         * expensive.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageResourceResult>.Builder} avoiding the
         * need to create one manually via {@link List<UsageResourceResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageResourceResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #topResources(List<UsageResourceResult>)}.
         * 
         * @param topResources
         *        a consumer that will call methods on {@link List<UsageResourceResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topResources(List<UsageResourceResult>)
         */
        Builder topResources(Consumer<UsageResourceResult.Builder>... topResources);
    }

    static final class BuilderImpl implements Builder {
        private List<UsageAccountResult> sumByAccount = DefaultSdkAutoConstructList.getInstance();

        private List<UsageDataSourceResult> sumByDataSource = DefaultSdkAutoConstructList.getInstance();

        private List<UsageResourceResult> sumByResource = DefaultSdkAutoConstructList.getInstance();

        private List<UsageResourceResult> topResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageStatistics model) {
            sumByAccount(model.sumByAccount);
            sumByDataSource(model.sumByDataSource);
            sumByResource(model.sumByResource);
            topResources(model.topResources);
        }

        public final Collection<UsageAccountResult.Builder> getSumByAccount() {
            if (sumByAccount instanceof SdkAutoConstructList) {
                return null;
            }
            return sumByAccount != null ? sumByAccount.stream().map(UsageAccountResult::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder sumByAccount(Collection<UsageAccountResult> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copy(sumByAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(UsageAccountResult... sumByAccount) {
            sumByAccount(Arrays.asList(sumByAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(Consumer<UsageAccountResult.Builder>... sumByAccount) {
            sumByAccount(Stream.of(sumByAccount).map(c -> UsageAccountResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSumByAccount(Collection<UsageAccountResult.BuilderImpl> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copyFromBuilder(sumByAccount);
        }

        public final Collection<UsageDataSourceResult.Builder> getSumByDataSource() {
            if (sumByDataSource instanceof SdkAutoConstructList) {
                return null;
            }
            return sumByDataSource != null ? sumByDataSource.stream().map(UsageDataSourceResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sumByDataSource(Collection<UsageDataSourceResult> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copy(sumByDataSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(UsageDataSourceResult... sumByDataSource) {
            sumByDataSource(Arrays.asList(sumByDataSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder>... sumByDataSource) {
            sumByDataSource(Stream.of(sumByDataSource).map(c -> UsageDataSourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSumByDataSource(Collection<UsageDataSourceResult.BuilderImpl> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copyFromBuilder(sumByDataSource);
        }

        public final Collection<UsageResourceResult.Builder> getSumByResource() {
            if (sumByResource instanceof SdkAutoConstructList) {
                return null;
            }
            return sumByResource != null ? sumByResource.stream().map(UsageResourceResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sumByResource(Collection<UsageResourceResult> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copy(sumByResource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(UsageResourceResult... sumByResource) {
            sumByResource(Arrays.asList(sumByResource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(Consumer<UsageResourceResult.Builder>... sumByResource) {
            sumByResource(Stream.of(sumByResource).map(c -> UsageResourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSumByResource(Collection<UsageResourceResult.BuilderImpl> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copyFromBuilder(sumByResource);
        }

        public final Collection<UsageResourceResult.Builder> getTopResources() {
            if (topResources instanceof SdkAutoConstructList) {
                return null;
            }
            return topResources != null ? topResources.stream().map(UsageResourceResult::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder topResources(Collection<UsageResourceResult> topResources) {
            this.topResources = UsageResourceResultListCopier.copy(topResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(UsageResourceResult... topResources) {
            topResources(Arrays.asList(topResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(Consumer<UsageResourceResult.Builder>... topResources) {
            topResources(Stream.of(topResources).map(c -> UsageResourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTopResources(Collection<UsageResourceResult.BuilderImpl> topResources) {
            this.topResources = UsageResourceResultListCopier.copyFromBuilder(topResources);
        }

        @Override
        public UsageStatistics build() {
            return new UsageStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
