/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.Condition;
import software.amazon.awssdk.services.guardduty.model.CriterionCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingCriteria> {
    private static final SdkField<Map<String, Condition>> CRITERION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Criterion").getter(FindingCriteria.getter(FindingCriteria::criterion)).setter(FindingCriteria.setter(Builder::criterion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criterion").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Condition> criterion;

    private FindingCriteria(BuilderImpl builder) {
        this.criterion = builder.criterion;
    }

    public boolean hasCriterion() {
        return this.criterion != null && !(this.criterion instanceof SdkAutoConstructMap);
    }

    public Map<String, Condition> criterion() {
        return this.criterion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.criterion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingCriteria)) {
            return false;
        }
        FindingCriteria other = (FindingCriteria)obj;
        return Objects.equals(this.criterion(), other.criterion());
    }

    public String toString() {
        return ToString.builder((String)"FindingCriteria").add("Criterion", this.criterion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Criterion": {
                return Optional.ofNullable(clazz.cast(this.criterion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingCriteria, T> g) {
        return obj -> g.apply((FindingCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Condition> criterion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingCriteria model) {
            this.criterion(model.criterion);
        }

        public final Map<String, Condition.Builder> getCriterion() {
            return this.criterion != null ? CollectionUtils.mapValues(this.criterion, Condition::toBuilder) : null;
        }

        @Override
        public final Builder criterion(Map<String, Condition> criterion) {
            this.criterion = CriterionCopier.copy(criterion);
            return this;
        }

        public final void setCriterion(Map<String, Condition.BuilderImpl> criterion) {
            this.criterion = CriterionCopier.copyFromBuilder(criterion);
        }

        public FindingCriteria build() {
            return new FindingCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingCriteria> {
        public Builder criterion(Map<String, Condition> var1);
    }
}

