/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Country
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Country> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(Country.getter(Country::countryCode)).setter(Country.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryCode").build()}).build();
    private static final SdkField<String> COUNTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryName").getter(Country.getter(Country::countryName)).setter(Country.setter(Builder::countryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD, COUNTRY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String countryCode;
    private final String countryName;

    private Country(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.countryName = builder.countryName;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String countryName() {
        return this.countryName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Country)) {
            return false;
        }
        Country other = (Country)obj;
        return Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.countryName(), other.countryName());
    }

    public String toString() {
        return ToString.builder((String)"Country").add("CountryCode", (Object)this.countryCode()).add("CountryName", (Object)this.countryName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "CountryName": {
                return Optional.ofNullable(clazz.cast(this.countryName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Country, T> g) {
        return obj -> g.apply((Country)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String countryCode;
        private String countryName;

        private BuilderImpl() {
        }

        private BuilderImpl(Country model) {
            this.countryCode(model.countryCode);
            this.countryName(model.countryName);
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getCountryName() {
            return this.countryName;
        }

        @Override
        public final Builder countryName(String countryName) {
            this.countryName = countryName;
            return this;
        }

        public final void setCountryName(String countryName) {
            this.countryName = countryName;
        }

        public Country build() {
            return new Country(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Country> {
        public Builder countryCode(String var1);

        public Builder countryName(String var1);
    }
}

