/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOrganizationConfigurationRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::detectorId)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnable").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::autoEnable)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final SdkField<OrganizationDataSourceConfigurations> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::dataSources)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::dataSources)).constructor(OrganizationDataSourceConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, AUTO_ENABLE_FIELD, DATA_SOURCES_FIELD));
    private final String detectorId;
    private final Boolean autoEnable;
    private final OrganizationDataSourceConfigurations dataSources;

    private UpdateOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.autoEnable = builder.autoEnable;
        this.dataSources = builder.dataSources;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public Boolean autoEnable() {
        return this.autoEnable;
    }

    public OrganizationDataSourceConfigurations dataSources() {
        return this.dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationConfigurationRequest)) {
            return false;
        }
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.autoEnable(), other.autoEnable()) && Objects.equals(this.dataSources(), other.dataSources());
    }

    public String toString() {
        return ToString.builder((String)"UpdateOrganizationConfigurationRequest").add("DetectorId", (Object)this.detectorId()).add("AutoEnable", (Object)this.autoEnable()).add("DataSources", (Object)this.dataSources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnable()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private Boolean autoEnable;
        private OrganizationDataSourceConfigurations dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationConfigurationRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.autoEnable(model.autoEnable);
            this.dataSources(model.dataSources);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Boolean getAutoEnable() {
            return this.autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        public final OrganizationDataSourceConfigurations.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Override
        public final Builder dataSources(OrganizationDataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final void setDataSources(OrganizationDataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationConfigurationRequest build() {
            return new UpdateOrganizationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
        public Builder detectorId(String var1);

        public Builder autoEnable(Boolean var1);

        public Builder dataSources(OrganizationDataSourceConfigurations var1);

        default public Builder dataSources(Consumer<OrganizationDataSourceConfigurations.Builder> dataSources) {
            return this.dataSources((OrganizationDataSourceConfigurations)((OrganizationDataSourceConfigurations.Builder)OrganizationDataSourceConfigurations.builder().applyMutation(dataSources)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

