/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DomainDetails;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiCallAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiCallAction> {
    private static final SdkField<String> API_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Api").getter(AwsApiCallAction.getter(AwsApiCallAction::api)).setter(AwsApiCallAction.setter(Builder::api)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("api").build()}).build();
    private static final SdkField<String> CALLER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerType").getter(AwsApiCallAction.getter(AwsApiCallAction::callerType)).setter(AwsApiCallAction.setter(Builder::callerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerType").build()}).build();
    private static final SdkField<DomainDetails> DOMAIN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::domainDetails)).setter(AwsApiCallAction.setter(Builder::domainDetails)).constructor(DomainDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainDetails").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(AwsApiCallAction.getter(AwsApiCallAction::errorCode)).setter(AwsApiCallAction.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::remoteIpDetails)).setter(AwsApiCallAction.setter(Builder::remoteIpDetails)).constructor(RemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(AwsApiCallAction.getter(AwsApiCallAction::serviceName)).setter(AwsApiCallAction.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD, CALLER_TYPE_FIELD, DOMAIN_DETAILS_FIELD, ERROR_CODE_FIELD, REMOTE_IP_DETAILS_FIELD, SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String api;
    private final String callerType;
    private final DomainDetails domainDetails;
    private final String errorCode;
    private final RemoteIpDetails remoteIpDetails;
    private final String serviceName;

    private AwsApiCallAction(BuilderImpl builder) {
        this.api = builder.api;
        this.callerType = builder.callerType;
        this.domainDetails = builder.domainDetails;
        this.errorCode = builder.errorCode;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.serviceName = builder.serviceName;
    }

    public String api() {
        return this.api;
    }

    public String callerType() {
        return this.callerType;
    }

    public DomainDetails domainDetails() {
        return this.domainDetails;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.api());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiCallAction)) {
            return false;
        }
        AwsApiCallAction other = (AwsApiCallAction)obj;
        return Objects.equals(this.api(), other.api()) && Objects.equals(this.callerType(), other.callerType()) && Objects.equals(this.domainDetails(), other.domainDetails()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public String toString() {
        return ToString.builder((String)"AwsApiCallAction").add("Api", (Object)this.api()).add("CallerType", (Object)this.callerType()).add("DomainDetails", (Object)this.domainDetails()).add("ErrorCode", (Object)this.errorCode()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Api": {
                return Optional.ofNullable(clazz.cast(this.api()));
            }
            case "CallerType": {
                return Optional.ofNullable(clazz.cast(this.callerType()));
            }
            case "DomainDetails": {
                return Optional.ofNullable(clazz.cast(this.domainDetails()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiCallAction, T> g) {
        return obj -> g.apply((AwsApiCallAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String api;
        private String callerType;
        private DomainDetails domainDetails;
        private String errorCode;
        private RemoteIpDetails remoteIpDetails;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiCallAction model) {
            this.api(model.api);
            this.callerType(model.callerType);
            this.domainDetails(model.domainDetails);
            this.errorCode(model.errorCode);
            this.remoteIpDetails(model.remoteIpDetails);
            this.serviceName(model.serviceName);
        }

        public final String getApi() {
            return this.api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        public final String getCallerType() {
            return this.callerType;
        }

        @Override
        public final Builder callerType(String callerType) {
            this.callerType = callerType;
            return this;
        }

        public final void setCallerType(String callerType) {
            this.callerType = callerType;
        }

        public final DomainDetails.Builder getDomainDetails() {
            return this.domainDetails != null ? this.domainDetails.toBuilder() : null;
        }

        @Override
        public final Builder domainDetails(DomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final void setDomainDetails(DomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public AwsApiCallAction build() {
            return new AwsApiCallAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiCallAction> {
        public Builder api(String var1);

        public Builder callerType(String var1);

        public Builder domainDetails(DomainDetails var1);

        default public Builder domainDetails(Consumer<DomainDetails.Builder> domainDetails) {
            return this.domainDetails((DomainDetails)((DomainDetails.Builder)DomainDetails.builder().applyMutation(domainDetails)).build());
        }

        public Builder errorCode(String var1);

        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder serviceName(String var1);
    }
}

