/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.UsageAccountResult;
import software.amazon.awssdk.services.guardduty.model.UsageAccountResultListCopier;
import software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult;
import software.amazon.awssdk.services.guardduty.model.UsageDataSourceResultListCopier;
import software.amazon.awssdk.services.guardduty.model.UsageResourceResult;
import software.amazon.awssdk.services.guardduty.model.UsageResourceResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageStatistics> {
    private static final SdkField<List<UsageAccountResult>> SUM_BY_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByAccount").getter(UsageStatistics.getter(UsageStatistics::sumByAccount)).setter(UsageStatistics.setter(Builder::sumByAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByAccount").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageAccountResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageDataSourceResult>> SUM_BY_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByDataSource").getter(UsageStatistics.getter(UsageStatistics::sumByDataSource)).setter(UsageStatistics.setter(Builder::sumByDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByDataSource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageDataSourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageResourceResult>> SUM_BY_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SumByResource").getter(UsageStatistics.getter(UsageStatistics::sumByResource)).setter(UsageStatistics.setter(Builder::sumByResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByResource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageResourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageResourceResult>> TOP_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopResources").getter(UsageStatistics.getter(UsageStatistics::topResources)).setter(UsageStatistics.setter(Builder::topResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageResourceResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUM_BY_ACCOUNT_FIELD, SUM_BY_DATA_SOURCE_FIELD, SUM_BY_RESOURCE_FIELD, TOP_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<UsageAccountResult> sumByAccount;
    private final List<UsageDataSourceResult> sumByDataSource;
    private final List<UsageResourceResult> sumByResource;
    private final List<UsageResourceResult> topResources;

    private UsageStatistics(BuilderImpl builder) {
        this.sumByAccount = builder.sumByAccount;
        this.sumByDataSource = builder.sumByDataSource;
        this.sumByResource = builder.sumByResource;
        this.topResources = builder.topResources;
    }

    public boolean hasSumByAccount() {
        return this.sumByAccount != null && !(this.sumByAccount instanceof SdkAutoConstructList);
    }

    public List<UsageAccountResult> sumByAccount() {
        return this.sumByAccount;
    }

    public boolean hasSumByDataSource() {
        return this.sumByDataSource != null && !(this.sumByDataSource instanceof SdkAutoConstructList);
    }

    public List<UsageDataSourceResult> sumByDataSource() {
        return this.sumByDataSource;
    }

    public boolean hasSumByResource() {
        return this.sumByResource != null && !(this.sumByResource instanceof SdkAutoConstructList);
    }

    public List<UsageResourceResult> sumByResource() {
        return this.sumByResource;
    }

    public boolean hasTopResources() {
        return this.topResources != null && !(this.topResources instanceof SdkAutoConstructList);
    }

    public List<UsageResourceResult> topResources() {
        return this.topResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByAccount() ? this.sumByAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByDataSource() ? this.sumByDataSource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSumByResource() ? this.sumByResource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopResources() ? this.topResources() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageStatistics)) {
            return false;
        }
        UsageStatistics other = (UsageStatistics)obj;
        return this.hasSumByAccount() == other.hasSumByAccount() && Objects.equals(this.sumByAccount(), other.sumByAccount()) && this.hasSumByDataSource() == other.hasSumByDataSource() && Objects.equals(this.sumByDataSource(), other.sumByDataSource()) && this.hasSumByResource() == other.hasSumByResource() && Objects.equals(this.sumByResource(), other.sumByResource()) && this.hasTopResources() == other.hasTopResources() && Objects.equals(this.topResources(), other.topResources());
    }

    public String toString() {
        return ToString.builder((String)"UsageStatistics").add("SumByAccount", this.hasSumByAccount() ? this.sumByAccount() : null).add("SumByDataSource", this.hasSumByDataSource() ? this.sumByDataSource() : null).add("SumByResource", this.hasSumByResource() ? this.sumByResource() : null).add("TopResources", this.hasTopResources() ? this.topResources() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SumByAccount": {
                return Optional.ofNullable(clazz.cast(this.sumByAccount()));
            }
            case "SumByDataSource": {
                return Optional.ofNullable(clazz.cast(this.sumByDataSource()));
            }
            case "SumByResource": {
                return Optional.ofNullable(clazz.cast(this.sumByResource()));
            }
            case "TopResources": {
                return Optional.ofNullable(clazz.cast(this.topResources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageStatistics, T> g) {
        return obj -> g.apply((UsageStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UsageAccountResult> sumByAccount = DefaultSdkAutoConstructList.getInstance();
        private List<UsageDataSourceResult> sumByDataSource = DefaultSdkAutoConstructList.getInstance();
        private List<UsageResourceResult> sumByResource = DefaultSdkAutoConstructList.getInstance();
        private List<UsageResourceResult> topResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageStatistics model) {
            this.sumByAccount(model.sumByAccount);
            this.sumByDataSource(model.sumByDataSource);
            this.sumByResource(model.sumByResource);
            this.topResources(model.topResources);
        }

        public final Collection<UsageAccountResult.Builder> getSumByAccount() {
            if (this.sumByAccount instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sumByAccount != null ? (Collection)this.sumByAccount.stream().map(UsageAccountResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sumByAccount(Collection<UsageAccountResult> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copy(sumByAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(UsageAccountResult ... sumByAccount) {
            this.sumByAccount(Arrays.asList(sumByAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(Consumer<UsageAccountResult.Builder> ... sumByAccount) {
            this.sumByAccount(Stream.of(sumByAccount).map(c -> (UsageAccountResult)((UsageAccountResult.Builder)UsageAccountResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSumByAccount(Collection<UsageAccountResult.BuilderImpl> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copyFromBuilder(sumByAccount);
        }

        public final Collection<UsageDataSourceResult.Builder> getSumByDataSource() {
            if (this.sumByDataSource instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sumByDataSource != null ? (Collection)this.sumByDataSource.stream().map(UsageDataSourceResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sumByDataSource(Collection<UsageDataSourceResult> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copy(sumByDataSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(UsageDataSourceResult ... sumByDataSource) {
            this.sumByDataSource(Arrays.asList(sumByDataSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder> ... sumByDataSource) {
            this.sumByDataSource(Stream.of(sumByDataSource).map(c -> (UsageDataSourceResult)((UsageDataSourceResult.Builder)UsageDataSourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSumByDataSource(Collection<UsageDataSourceResult.BuilderImpl> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copyFromBuilder(sumByDataSource);
        }

        public final Collection<UsageResourceResult.Builder> getSumByResource() {
            if (this.sumByResource instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sumByResource != null ? (Collection)this.sumByResource.stream().map(UsageResourceResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sumByResource(Collection<UsageResourceResult> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copy(sumByResource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(UsageResourceResult ... sumByResource) {
            this.sumByResource(Arrays.asList(sumByResource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(Consumer<UsageResourceResult.Builder> ... sumByResource) {
            this.sumByResource(Stream.of(sumByResource).map(c -> (UsageResourceResult)((UsageResourceResult.Builder)UsageResourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSumByResource(Collection<UsageResourceResult.BuilderImpl> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copyFromBuilder(sumByResource);
        }

        public final Collection<UsageResourceResult.Builder> getTopResources() {
            if (this.topResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topResources != null ? (Collection)this.topResources.stream().map(UsageResourceResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topResources(Collection<UsageResourceResult> topResources) {
            this.topResources = UsageResourceResultListCopier.copy(topResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(UsageResourceResult ... topResources) {
            this.topResources(Arrays.asList(topResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(Consumer<UsageResourceResult.Builder> ... topResources) {
            this.topResources(Stream.of(topResources).map(c -> (UsageResourceResult)((UsageResourceResult.Builder)UsageResourceResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopResources(Collection<UsageResourceResult.BuilderImpl> topResources) {
            this.topResources = UsageResourceResultListCopier.copyFromBuilder(topResources);
        }

        public UsageStatistics build() {
            return new UsageStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageStatistics> {
        public Builder sumByAccount(Collection<UsageAccountResult> var1);

        public Builder sumByAccount(UsageAccountResult ... var1);

        public Builder sumByAccount(Consumer<UsageAccountResult.Builder> ... var1);

        public Builder sumByDataSource(Collection<UsageDataSourceResult> var1);

        public Builder sumByDataSource(UsageDataSourceResult ... var1);

        public Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder> ... var1);

        public Builder sumByResource(Collection<UsageResourceResult> var1);

        public Builder sumByResource(UsageResourceResult ... var1);

        public Builder sumByResource(Consumer<UsageResourceResult.Builder> ... var1);

        public Builder topResources(Collection<UsageResourceResult> var1);

        public Builder topResources(UsageResourceResult ... var1);

        public Builder topResources(Consumer<UsageResourceResult.Builder> ... var1);
    }
}

