/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;

public class ListDetectorsPublisher
implements SdkPublisher<ListDetectorsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDetectorsPublisher(GuardDutyAsyncClient client, ListDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDetectorsPublisher(GuardDutyAsyncClient client, ListDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> detectorIds() {
        Function<ListDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.detectorIds() != null) {
                return response.detectorIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDetectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDetectorsResponseFetcher
    implements AsyncPageFetcher<ListDetectorsResponse> {
        private ListDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDetectorsResponse> nextPage(ListDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListDetectorsPublisher.this.client.listDetectors(ListDetectorsPublisher.this.firstRequest);
            }
            return ListDetectorsPublisher.this.client.listDetectors((ListDetectorsRequest)((Object)ListDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

