/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FilterAction {
    NOOP("NOOP"),
    ARCHIVE("ARCHIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FilterAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FilterAction.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterAction> knownValues() {
        return Stream.of(FilterAction.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

