/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpSetRequest extends GuardDutyRequest implements
        ToCopyableBuilder<CreateIpSetRequest.Builder, CreateIpSetRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpSetRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpSetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpSetRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpSetRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Boolean> ACTIVATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateIpSetRequest::activate)).setter(setter(Builder::activate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activate").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpSetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateIpSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, NAME_FIELD,
            FORMAT_FIELD, LOCATION_FIELD, ACTIVATE_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String detectorId;

    private final String name;

    private final String format;

    private final String location;

    private final Boolean activate;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.name = builder.name;
        this.format = builder.format;
        this.location = builder.location;
        this.activate = builder.activate;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique ID of the detector of the GuardDuty account for which you want to create an IPSet.
     * </p>
     * 
     * @return The unique ID of the detector of the GuardDuty account for which you want to create an IPSet.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The user friendly name to identify the IPSet. This name is displayed in all findings that are triggered by
     * activity that involves IP addresses included in this IPSet.
     * </p>
     * 
     * @return The user friendly name to identify the IPSet. This name is displayed in all findings that are triggered
     *         by activity that involves IP addresses included in this IPSet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The format of the file that contains the IPSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link IpSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the IPSet.
     * @see IpSetFormat
     */
    public IpSetFormat format() {
        return IpSetFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the file that contains the IPSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link IpSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the IPSet.
     * @see IpSetFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The URI of the file that contains the IPSet. For example
     * (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
     * </p>
     * 
     * @return The URI of the file that contains the IPSet. For example
     *         (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * A boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.
     * </p>
     * 
     * @return A boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.
     */
    public Boolean activate() {
        return activate;
    }

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @return The idempotency token for the create request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be added to a new IP set resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be added to a new IP set resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(activate());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpSetRequest)) {
            return false;
        }
        CreateIpSetRequest other = (CreateIpSetRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(name(), other.name())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(activate(), other.activate()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateIpSetRequest").add("DetectorId", detectorId()).add("Name", name())
                .add("Format", formatAsString()).add("Location", location()).add("Activate", activate())
                .add("ClientToken", clientToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Activate":
            return Optional.ofNullable(clazz.cast(activate()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpSetRequest, T> g) {
        return obj -> g.apply((CreateIpSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpSetRequest> {
        /**
         * <p>
         * The unique ID of the detector of the GuardDuty account for which you want to create an IPSet.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector of the GuardDuty account for which you want to create an IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The user friendly name to identify the IPSet. This name is displayed in all findings that are triggered by
         * activity that involves IP addresses included in this IPSet.
         * </p>
         * 
         * @param name
         *        The user friendly name to identify the IPSet. This name is displayed in all findings that are
         *        triggered by activity that involves IP addresses included in this IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the file that contains the IPSet.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the IPSet.
         * @see IpSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the file that contains the IPSet.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the IPSet.
         * @see IpSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetFormat
         */
        Builder format(IpSetFormat format);

        /**
         * <p>
         * The URI of the file that contains the IPSet. For example
         * (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
         * </p>
         * 
         * @param location
         *        The URI of the file that contains the IPSet. For example
         *        (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * A boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.
         * </p>
         * 
         * @param activate
         *        A boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activate(Boolean activate);

        /**
         * <p>
         * The idempotency token for the create request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the create request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to be added to a new IP set resource.
         * </p>
         * 
         * @param tags
         *        The tags to be added to a new IP set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String name;

        private String format;

        private String location;

        private Boolean activate;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpSetRequest model) {
            super(model);
            detectorId(model.detectorId);
            name(model.name);
            format(model.format);
            location(model.location);
            activate(model.activate);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFormatAsString() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(IpSetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Boolean getActivate() {
            return activate;
        }

        @Override
        public final Builder activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        public final void setActivate(Boolean activate) {
            this.activate = activate;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpSetRequest build() {
            return new CreateIpSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
