/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EphemerisDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EphemerisDescription> {
    private static final SdkField<S3Object> SOURCE_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceS3Object").getter(EphemerisDescription.getter(EphemerisDescription::sourceS3Object)).setter(EphemerisDescription.setter(Builder::sourceS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3Object").build()}).build();
    private static final SdkField<String> EPHEMERIS_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisData").getter(EphemerisDescription.getter(EphemerisDescription::ephemerisData)).setter(EphemerisDescription.setter(Builder::ephemerisData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_S3_OBJECT_FIELD, EPHEMERIS_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EphemerisDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Object sourceS3Object;
    private final String ephemerisData;

    private EphemerisDescription(BuilderImpl builder) {
        this.sourceS3Object = builder.sourceS3Object;
        this.ephemerisData = builder.ephemerisData;
    }

    public final S3Object sourceS3Object() {
        return this.sourceS3Object;
    }

    public final String ephemerisData() {
        return this.ephemerisData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisDescription)) {
            return false;
        }
        EphemerisDescription other = (EphemerisDescription)obj;
        return Objects.equals(this.sourceS3Object(), other.sourceS3Object()) && Objects.equals(this.ephemerisData(), other.ephemerisData());
    }

    public final String toString() {
        return ToString.builder((String)"EphemerisDescription").add("SourceS3Object", (Object)this.sourceS3Object()).add("EphemerisData", (Object)this.ephemerisData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceS3Object": {
                return Optional.ofNullable(clazz.cast(this.sourceS3Object()));
            }
            case "ephemerisData": {
                return Optional.ofNullable(clazz.cast(this.ephemerisData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceS3Object", SOURCE_S3_OBJECT_FIELD);
        map.put("ephemerisData", EPHEMERIS_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EphemerisDescription, T> g) {
        return obj -> g.apply((EphemerisDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object sourceS3Object;
        private String ephemerisData;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisDescription model) {
            this.sourceS3Object(model.sourceS3Object);
            this.ephemerisData(model.ephemerisData);
        }

        public final S3Object.Builder getSourceS3Object() {
            return this.sourceS3Object != null ? this.sourceS3Object.toBuilder() : null;
        }

        public final void setSourceS3Object(S3Object.BuilderImpl sourceS3Object) {
            this.sourceS3Object = sourceS3Object != null ? sourceS3Object.build() : null;
        }

        @Override
        public final Builder sourceS3Object(S3Object sourceS3Object) {
            this.sourceS3Object = sourceS3Object;
            return this;
        }

        public final String getEphemerisData() {
            return this.ephemerisData;
        }

        public final void setEphemerisData(String ephemerisData) {
            this.ephemerisData = ephemerisData;
        }

        @Override
        public final Builder ephemerisData(String ephemerisData) {
            this.ephemerisData = ephemerisData;
            return this;
        }

        public EphemerisDescription build() {
            return new EphemerisDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EphemerisDescription> {
        public Builder sourceS3Object(S3Object var1);

        default public Builder sourceS3Object(Consumer<S3Object.Builder> sourceS3Object) {
            return this.sourceS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(sourceS3Object)).build());
        }

        public Builder ephemerisData(String var1);
    }
}

