/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.EndpointStatus;
import software.amazon.awssdk.services.groundstation.model.SocketAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataflowEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataflowEndpoint> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataflowEndpoint.getter(DataflowEndpoint::name)).setter(DataflowEndpoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<SocketAddress> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("address").getter(DataflowEndpoint.getter(DataflowEndpoint::address)).setter(DataflowEndpoint.setter(Builder::address)).constructor(SocketAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataflowEndpoint.getter(DataflowEndpoint::statusAsString)).setter(DataflowEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> MTU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("mtu").getter(DataflowEndpoint.getter(DataflowEndpoint::mtu)).setter(DataflowEndpoint.setter(Builder::mtu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ADDRESS_FIELD, STATUS_FIELD, MTU_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataflowEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final SocketAddress address;
    private final String status;
    private final Integer mtu;

    private DataflowEndpoint(BuilderImpl builder) {
        this.name = builder.name;
        this.address = builder.address;
        this.status = builder.status;
        this.mtu = builder.mtu;
    }

    public final String name() {
        return this.name;
    }

    public final SocketAddress address() {
        return this.address;
    }

    public final EndpointStatus status() {
        return EndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer mtu() {
        return this.mtu;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mtu());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpoint)) {
            return false;
        }
        DataflowEndpoint other = (DataflowEndpoint)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.mtu(), other.mtu());
    }

    public final String toString() {
        return ToString.builder((String)"DataflowEndpoint").add("Name", (Object)this.name()).add("Address", (Object)this.address()).add("Status", (Object)this.statusAsString()).add("Mtu", (Object)this.mtu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "mtu": {
                return Optional.ofNullable(clazz.cast(this.mtu()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("address", ADDRESS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("mtu", MTU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpoint, T> g) {
        return obj -> g.apply((DataflowEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private SocketAddress address;
        private String status;
        private Integer mtu;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpoint model) {
            this.name(model.name);
            this.address(model.address);
            this.status(model.status);
            this.mtu(model.mtu);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SocketAddress.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(SocketAddress.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(SocketAddress address) {
            this.address = address;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMtu() {
            return this.mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public DataflowEndpoint build() {
            return new DataflowEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataflowEndpoint> {
        public Builder name(String var1);

        public Builder address(SocketAddress var1);

        default public Builder address(Consumer<SocketAddress.Builder> address) {
            return this.address((SocketAddress)((SocketAddress.Builder)SocketAddress.builder().applyMutation(address)).build());
        }

        public Builder status(String var1);

        public Builder status(EndpointStatus var1);

        public Builder mtu(Integer var1);
    }
}

