/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.AgentStatus;
import software.amazon.awssdk.services.groundstation.model.AuditResults;
import software.amazon.awssdk.services.groundstation.model.ConnectionDetails;
import software.amazon.awssdk.services.groundstation.model.RangedConnectionDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsGroundStationAgentEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsGroundStationAgentEndpoint> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AwsGroundStationAgentEndpoint.getter(AwsGroundStationAgentEndpoint::name)).setter(AwsGroundStationAgentEndpoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ConnectionDetails> EGRESS_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("egressAddress").getter(AwsGroundStationAgentEndpoint.getter(AwsGroundStationAgentEndpoint::egressAddress)).setter(AwsGroundStationAgentEndpoint.setter(Builder::egressAddress)).constructor(ConnectionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAddress").build()}).build();
    private static final SdkField<RangedConnectionDetails> INGRESS_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ingressAddress").getter(AwsGroundStationAgentEndpoint.getter(AwsGroundStationAgentEndpoint::ingressAddress)).setter(AwsGroundStationAgentEndpoint.setter(Builder::ingressAddress)).constructor(RangedConnectionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAddress").build()}).build();
    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentStatus").getter(AwsGroundStationAgentEndpoint.getter(AwsGroundStationAgentEndpoint::agentStatusAsString)).setter(AwsGroundStationAgentEndpoint.setter(Builder::agentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()}).build();
    private static final SdkField<String> AUDIT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("auditResults").getter(AwsGroundStationAgentEndpoint.getter(AwsGroundStationAgentEndpoint::auditResultsAsString)).setter(AwsGroundStationAgentEndpoint.setter(Builder::auditResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EGRESS_ADDRESS_FIELD, INGRESS_ADDRESS_FIELD, AGENT_STATUS_FIELD, AUDIT_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsGroundStationAgentEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ConnectionDetails egressAddress;
    private final RangedConnectionDetails ingressAddress;
    private final String agentStatus;
    private final String auditResults;

    private AwsGroundStationAgentEndpoint(BuilderImpl builder) {
        this.name = builder.name;
        this.egressAddress = builder.egressAddress;
        this.ingressAddress = builder.ingressAddress;
        this.agentStatus = builder.agentStatus;
        this.auditResults = builder.auditResults;
    }

    public final String name() {
        return this.name;
    }

    public final ConnectionDetails egressAddress() {
        return this.egressAddress;
    }

    public final RangedConnectionDetails ingressAddress() {
        return this.ingressAddress;
    }

    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(this.agentStatus);
    }

    public final String agentStatusAsString() {
        return this.agentStatus;
    }

    public final AuditResults auditResults() {
        return AuditResults.fromValue(this.auditResults);
    }

    public final String auditResultsAsString() {
        return this.auditResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditResultsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsGroundStationAgentEndpoint)) {
            return false;
        }
        AwsGroundStationAgentEndpoint other = (AwsGroundStationAgentEndpoint)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.egressAddress(), other.egressAddress()) && Objects.equals(this.ingressAddress(), other.ingressAddress()) && Objects.equals(this.agentStatusAsString(), other.agentStatusAsString()) && Objects.equals(this.auditResultsAsString(), other.auditResultsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AwsGroundStationAgentEndpoint").add("Name", (Object)this.name()).add("EgressAddress", (Object)this.egressAddress()).add("IngressAddress", (Object)this.ingressAddress()).add("AgentStatus", (Object)this.agentStatusAsString()).add("AuditResults", (Object)this.auditResultsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "egressAddress": {
                return Optional.ofNullable(clazz.cast(this.egressAddress()));
            }
            case "ingressAddress": {
                return Optional.ofNullable(clazz.cast(this.ingressAddress()));
            }
            case "agentStatus": {
                return Optional.ofNullable(clazz.cast(this.agentStatusAsString()));
            }
            case "auditResults": {
                return Optional.ofNullable(clazz.cast(this.auditResultsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("egressAddress", EGRESS_ADDRESS_FIELD);
        map.put("ingressAddress", INGRESS_ADDRESS_FIELD);
        map.put("agentStatus", AGENT_STATUS_FIELD);
        map.put("auditResults", AUDIT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsGroundStationAgentEndpoint, T> g) {
        return obj -> g.apply((AwsGroundStationAgentEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ConnectionDetails egressAddress;
        private RangedConnectionDetails ingressAddress;
        private String agentStatus;
        private String auditResults;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsGroundStationAgentEndpoint model) {
            this.name(model.name);
            this.egressAddress(model.egressAddress);
            this.ingressAddress(model.ingressAddress);
            this.agentStatus(model.agentStatus);
            this.auditResults(model.auditResults);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectionDetails.Builder getEgressAddress() {
            return this.egressAddress != null ? this.egressAddress.toBuilder() : null;
        }

        public final void setEgressAddress(ConnectionDetails.BuilderImpl egressAddress) {
            this.egressAddress = egressAddress != null ? egressAddress.build() : null;
        }

        @Override
        public final Builder egressAddress(ConnectionDetails egressAddress) {
            this.egressAddress = egressAddress;
            return this;
        }

        public final RangedConnectionDetails.Builder getIngressAddress() {
            return this.ingressAddress != null ? this.ingressAddress.toBuilder() : null;
        }

        public final void setIngressAddress(RangedConnectionDetails.BuilderImpl ingressAddress) {
            this.ingressAddress = ingressAddress != null ? ingressAddress.build() : null;
        }

        @Override
        public final Builder ingressAddress(RangedConnectionDetails ingressAddress) {
            this.ingressAddress = ingressAddress;
            return this;
        }

        public final String getAgentStatus() {
            return this.agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getAuditResults() {
            return this.auditResults;
        }

        public final void setAuditResults(String auditResults) {
            this.auditResults = auditResults;
        }

        @Override
        public final Builder auditResults(String auditResults) {
            this.auditResults = auditResults;
            return this;
        }

        @Override
        public final Builder auditResults(AuditResults auditResults) {
            this.auditResults(auditResults == null ? null : auditResults.toString());
            return this;
        }

        public AwsGroundStationAgentEndpoint build() {
            return new AwsGroundStationAgentEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsGroundStationAgentEndpoint> {
        public Builder name(String var1);

        public Builder egressAddress(ConnectionDetails var1);

        default public Builder egressAddress(Consumer<ConnectionDetails.Builder> egressAddress) {
            return this.egressAddress((ConnectionDetails)((ConnectionDetails.Builder)ConnectionDetails.builder().applyMutation(egressAddress)).build());
        }

        public Builder ingressAddress(RangedConnectionDetails var1);

        default public Builder ingressAddress(Consumer<RangedConnectionDetails.Builder> ingressAddress) {
            return this.ingressAddress((RangedConnectionDetails)((RangedConnectionDetails.Builder)RangedConnectionDetails.builder().applyMutation(ingressAddress)).build());
        }

        public Builder agentStatus(String var1);

        public Builder agentStatus(AgentStatus var1);

        public Builder auditResults(String var1);

        public Builder auditResults(AuditResults var1);
    }
}

