/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEphemeridesRequest extends GroundStationRequest implements
        ToCopyableBuilder<ListEphemeridesRequest.Builder, ListEphemeridesRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListEphemeridesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEphemeridesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEphemeridesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("satelliteId").getter(getter(ListEphemeridesRequest::satelliteId)).setter(setter(Builder::satelliteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListEphemeridesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusList")
            .getter(getter(ListEphemeridesRequest::statusListAsStrings))
            .setter(setter(Builder::statusListWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SATELLITE_ID_FIELD, START_TIME_FIELD, STATUS_LIST_FIELD));

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private final String satelliteId;

    private final Instant startTime;

    private final List<String> statusList;

    private ListEphemeridesRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.satelliteId = builder.satelliteId;
        this.startTime = builder.startTime;
        this.statusList = builder.statusList;
    }

    /**
     * <p>
     * The end time to list in UTC. The operation will return an ephemeris if its expiration time is within the time
     * range defined by the <code>startTime</code> and <code>endTime</code>.
     * </p>
     * 
     * @return The end time to list in UTC. The operation will return an ephemeris if its expiration time is within the
     *         time range defined by the <code>startTime</code> and <code>endTime</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Maximum number of ephemerides to return.
     * </p>
     * 
     * @return Maximum number of ephemerides to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The AWS Ground Station satellite ID to list ephemeris for.
     * </p>
     * 
     * @return The AWS Ground Station satellite ID to list ephemeris for.
     */
    public final String satelliteId() {
        return satelliteId;
    }

    /**
     * <p>
     * The start time to list in UTC. The operation will return an ephemeris if its expiration time is within the time
     * range defined by the <code>startTime</code> and <code>endTime</code>.
     * </p>
     * 
     * @return The start time to list in UTC. The operation will return an ephemeris if its expiration time is within
     *         the time range defined by the <code>startTime</code> and <code>endTime</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The list of ephemeris status to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusList} method.
     * </p>
     * 
     * @return The list of ephemeris status to return.
     */
    public final List<EphemerisStatus> statusList() {
        return EphemerisStatusListCopier.copyStringToEnum(statusList);
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatusList() {
        return statusList != null && !(statusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ephemeris status to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusList} method.
     * </p>
     * 
     * @return The list of ephemeris status to return.
     */
    public final List<String> statusListAsStrings() {
        return statusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusList() ? statusListAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEphemeridesRequest)) {
            return false;
        }
        ListEphemeridesRequest other = (ListEphemeridesRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(satelliteId(), other.satelliteId())
                && Objects.equals(startTime(), other.startTime()) && hasStatusList() == other.hasStatusList()
                && Objects.equals(statusListAsStrings(), other.statusListAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEphemeridesRequest").add("EndTime", endTime()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SatelliteId", satelliteId()).add("StartTime", startTime())
                .add("StatusList", hasStatusList() ? statusListAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "satelliteId":
            return Optional.ofNullable(clazz.cast(satelliteId()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "statusList":
            return Optional.ofNullable(clazz.cast(statusListAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEphemeridesRequest, T> g) {
        return obj -> g.apply((ListEphemeridesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEphemeridesRequest> {
        /**
         * <p>
         * The end time to list in UTC. The operation will return an ephemeris if its expiration time is within the time
         * range defined by the <code>startTime</code> and <code>endTime</code>.
         * </p>
         * 
         * @param endTime
         *        The end time to list in UTC. The operation will return an ephemeris if its expiration time is within
         *        the time range defined by the <code>startTime</code> and <code>endTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Maximum number of ephemerides to return.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of ephemerides to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The AWS Ground Station satellite ID to list ephemeris for.
         * </p>
         * 
         * @param satelliteId
         *        The AWS Ground Station satellite ID to list ephemeris for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteId(String satelliteId);

        /**
         * <p>
         * The start time to list in UTC. The operation will return an ephemeris if its expiration time is within the
         * time range defined by the <code>startTime</code> and <code>endTime</code>.
         * </p>
         * 
         * @param startTime
         *        The start time to list in UTC. The operation will return an ephemeris if its expiration time is within
         *        the time range defined by the <code>startTime</code> and <code>endTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The list of ephemeris status to return.
         * </p>
         * 
         * @param statusList
         *        The list of ephemeris status to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusListWithStrings(Collection<String> statusList);

        /**
         * <p>
         * The list of ephemeris status to return.
         * </p>
         * 
         * @param statusList
         *        The list of ephemeris status to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusListWithStrings(String... statusList);

        /**
         * <p>
         * The list of ephemeris status to return.
         * </p>
         * 
         * @param statusList
         *        The list of ephemeris status to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(Collection<EphemerisStatus> statusList);

        /**
         * <p>
         * The list of ephemeris status to return.
         * </p>
         * 
         * @param statusList
         *        The list of ephemeris status to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(EphemerisStatus... statusList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private String satelliteId;

        private Instant startTime;

        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEphemeridesRequest model) {
            super(model);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            satelliteId(model.satelliteId);
            startTime(model.startTime);
            statusListWithStrings(model.statusList);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSatelliteId() {
            return satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = EphemerisStatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusListWithStrings(Collection<String> statusList) {
            this.statusList = EphemerisStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusListWithStrings(String... statusList) {
            statusListWithStrings(Arrays.asList(statusList));
            return this;
        }

        @Override
        public final Builder statusList(Collection<EphemerisStatus> statusList) {
            this.statusList = EphemerisStatusListCopier.copyEnumToString(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(EphemerisStatus... statusList) {
            statusList(Arrays.asList(statusList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEphemeridesRequest build() {
            return new ListEphemeridesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
